/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

class GraphPanel
extends JPanel
implements MouseInputListener,
ChangeListener {
    private static final int R = 10;
    private static final int ANGLE_R = 50;
    private Color tempColor = Color.cyan;
    public static final int ADDPOINT = 1;
    public static final int DEFAULT = 1;
    public static final int ZOOMIN = 10;
    public static final int ZOOMOUT = 11;
    public static final int ZOOMCUST = 12;
    public static final int ZOOMRECT = 13;
    public static final int ROTATE = 14;
    private int mode = 1;
    private Document document;
    private boolean searchHulpPoint = false;
    private boolean searchCenter = false;
    private boolean searchAngle = false;
    private int selectedPointIndex = -1;
    private Point selectedPoint;
    private double originalX;
    private double originalY;
    private Point zoomRectA;
    private Point zoomRectB;
    private int centerX = -1;
    private int centerY = -1;
    private int arcX = -1;
    private int arcY = -1;

    public GraphPanel(Document document) {
        super(new BorderLayout());
        this.document = document;
        this.setSize(200, 200);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        document.getData().addChangeListener(this);
        this.setAutoscrolls(true);
        this.revalidate();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (mode == 13) {
            this.setCursor(new Cursor(12));
        } else if (mode == 14) {
            this.setCursor(new Cursor(13));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.document.refresh();
        this.repaint();
    }

    public int getMode() {
        return this.mode;
    }

    public void startSearchHulpPoint() {
        this.searchHulpPoint = true;
        this.setCursor(new Cursor(13));
        this.repaint();
    }

    public void stopSearchHulpPoint() {
        this.searchHulpPoint = false;
        this.setCursor(new Cursor(0));
        this.setMode(1);
        this.repaint();
    }

    public void startSearchCenter() {
        this.centerX = -1;
        this.centerY = -1;
        this.searchCenter = true;
        this.setCursor(new Cursor(13));
        this.repaint();
    }

    public void stopSearchCenter() {
        this.arcX = -1;
        this.arcY = -1;
        this.searchCenter = false;
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(this.document.getEnvironment().getBackgroundColor());
        this.document.paintCurve(g);
        this.document.paintLines(g);
        this.document.paintPoints(g);
        if (this.document.getShowHulpConstructie()) {
            this.document.paintHulpConstructie(g);
        }
        if (this.document.getShowBezier()) {
            this.document.paintBezier(g);
        }
        if (this.document.getShowNodes()) {
            this.document.paintNodes(g);
        }
        if (this.mode == 13) {
            this.paintZoomRect(g);
        }
        if (this.searchCenter) {
            this.paintCenterLocator(g);
        }
        if (this.mode == 14 && this.searchAngle) {
            this.paintAngle(g);
        }
        Rectangle scope = this.document.fit();
        int w = scope.width + Math.min(0, scope.x) + 20;
        int h = scope.height + Math.min(0, scope.y) + 20;
        this.setPreferredSize(new Dimension(w, h));
        this.revalidate();
        this.document.refresh();
    }

    private void paintZoomRect(Graphics gg) {
        if (this.zoomRectA == null || this.zoomRectB == null) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(1.0f));
        int xA = (int)this.zoomRectA.getX();
        int yA = (int)this.zoomRectA.getY();
        int xB = (int)this.zoomRectB.getX();
        int yB = (int)this.zoomRectB.getY();
        int w = Math.abs(xA - xB);
        int h = Math.abs(yA - yB);
        g.setColor(this.tempColor);
        int x = Math.min(xA, xB);
        int y = Math.min(yA, yB);
        g.drawRect(x, y, w, h);
    }

    private void paintCenterLocator(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(this.tempColor);
        g.drawLine(this.centerX, 0, this.centerX, this.getHeight());
        g.drawLine(0, this.centerY, this.getWidth(), this.centerY);
    }

    private void paintAngle(Graphics g) {
        g.setColor(this.tempColor);
        int angle = this.getAngle(this.centerX, this.centerY, this.arcX, this.arcY);
        g.fillArc(this.centerX - 25, this.centerY - 25, 50, 50, 0, angle);
        g.drawString(angle + "\u00b0", this.centerX + 25, this.centerY - 25);
    }

    public void stateChanged(ChangeEvent e) {
        this.document.refresh();
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.showToolTip(x, y);
        if (this.mode == 10 || this.mode == 11 || this.mode == 12) {
            return;
        }
        if (this.mode == 13) {
            this.zoomRectA = new Point(x, y);
        } else {
            int index = this.document.getData().getPoint(x, y, 10.0);
            if (index >= 0) {
                this.document.createUndoable();
                this.selectedPointIndex = index;
                this.selectedPoint = this.document.getData().getPoint(index);
                double originalX = this.selectedPoint.getX();
                double originalY = this.selectedPoint.getY();
                this.document.startDrag();
            }
        }
        Rectangle r = new Rectangle(x, y, 10, 10);
        ((JPanel)e.getSource()).scrollRectToVisible(r);
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.showToolTip(x, y);
        if (this.mode == 13) {
            double w = Math.abs(this.zoomRectA.getX() - (double)x);
            double h = Math.abs(this.zoomRectA.getY() - (double)y);
            double scaleX = (double)this.getWidth() / w;
            double scaleY = (double)this.getHeight() / h;
            double centerX = (this.zoomRectA.getX() + (double)x) / 2.0;
            double centerY = (this.zoomRectA.getY() + (double)y) / 2.0;
            this.document.createUndoable();
            this.document.getData().zoom(new Point(centerX, centerY), scaleX, scaleY);
            this.zoomRectA = null;
            this.zoomRectB = null;
            Rectangle r = new Rectangle((int)(centerX - (double)(this.getWidth() / 2)), (int)(centerY - (double)(this.getHeight() / 2)), this.getWidth(), this.getHeight());
            ((JPanel)e.getSource()).scrollRectToVisible(r);
        } else {
            if (this.selectedPointIndex >= 0 && this.selectedPoint != null) {
                if (x < 5 || y < 5) {
                    this.document.undoWithoutRedo();
                }
                this.selectedPointIndex = -1;
                this.selectedPoint = null;
            }
            Rectangle r = new Rectangle(x, y, 10, 10);
            ((JPanel)e.getSource()).scrollRectToVisible(r);
        }
        this.document.stopDrag();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.setToolTipText(x + "," + y);
        if (this.mode == 13) {
            this.zoomRectB = new Point(x, y);
            this.repaint();
        } else if (this.selectedPoint != null && this.selectedPointIndex >= 0 && x > 5 && y > 5) {
            Point p = new Point(x, y);
            this.document.getData().setPoint(this.selectedPointIndex, p);
            this.document.startDrag();
        }
        Rectangle r = new Rectangle(x, y, 10, 10);
        ((JPanel)e.getSource()).scrollRectToVisible(r);
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.showToolTip(x, y);
        if (this.mode == 10) {
            this.document.createUndoable();
            this.document.getData().zoom(new Point(x, y), Math.sqrt(2.0));
            return;
        }
        if (this.mode == 11) {
            this.document.createUndoable();
            this.document.getData().zoom(new Point(x, y), Math.sqrt(2.0) / 2.0);
            return;
        }
        if (this.mode == 12) {
            ZoomDialog dialog = new ZoomDialog(this.document.getGraphFrame());
            while (!dialog.showDialog()) {
            }
            double zoom = (double)dialog.getZoomPercentage() / 100.0;
            this.document.createUndoable();
            this.document.getData().zoom(new Point(x, y), zoom);
            this.stopSearchCenter();
            this.setMode(1);
            return;
        }
        if (this.mode == 14) {
            if (this.searchCenter) {
                this.searchCenter = false;
                this.searchAngle = true;
            } else if (this.searchAngle) {
                this.document.createUndoable();
                int angle = this.getAngle(this.centerX, this.centerY, this.arcX, this.arcY);
                this.document.getData().rotate(new Point(this.centerX, this.centerY), -angle);
                this.searchAngle = false;
                this.stopSearchCenter();
                this.setMode(1);
            } else {
                this.setMode(1);
            }
            this.repaint();
            return;
        }
        if (this.document.getShowHulpConstructie() && this.document.getHulpT() < 0.0) {
            this.document.setHulpPoint(new Point(x, y));
            this.searchHulpPoint = false;
            this.setCursor(new Cursor(0));
            return;
        }
        int index = this.document.getData().getPoint(x, y, 10.0);
        if (index < 0) {
            this.document.createUndoable();
            Point p = new Point(x, y);
            Algoritme algo = this.document.getAlgoritme();
            if (algo != null) {
                algo.addPoint(p);
            } else {
                this.document.getData().addPoint(p);
            }
            this.repaint();
            return;
        }
        Rectangle r = new Rectangle(x, y, 10, 10);
        ((JPanel)e.getSource()).scrollRectToVisible(r);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.showToolTip(x, y);
        if (this.searchCenter) {
            this.centerX = x;
            this.centerY = y;
            this.repaint();
        }
        if (this.searchAngle) {
            this.arcX = x;
            this.arcY = y;
            this.repaint();
        }
    }

    private void showToolTip(int x, int y) {
        int index = this.document.getData().getPoint(x, y, 10.0);
        if (index >= 0) {
            Point p = this.document.getData().getPoint(index);
            int pX = (int)p.getX();
            int pY = (int)p.getY();
            this.setToolTipText(pX + "," + pY);
            this.document.setLocationText(pX + "," + pY, true);
        } else {
            this.setToolTipText("");
            this.document.setLocationText(x + "," + y, false);
        }
    }

    private int getAngle(int x1, int y1, int x2, int y2) {
        double t = (double)Math.abs(y1 - y2) / (double)Math.abs(x1 - x2);
        int angle = (int)(Math.atan(t) * 180.0 / Math.PI);
        if (x2 < x1) {
            if (y2 < y1) {
                return 180 - angle;
            }
            return 180 + angle;
        }
        if (y2 >= y1) {
            return 360 - angle;
        }
        return angle;
    }
}

