/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class GraphicsEnvironment
implements Environment {
    private String[] name = new String[]{"Achtergrondkleur", "Puntkleur", "Re\u00eble knoop", "Virtuele knoop", "Kleur curve", "Verbindingslijnen", "Geselecteerd punt op curve", "Kleur hulpconstructie", "Kleur assen", "Voorstelling knooppunt", "Bezier representatie"};
    private Color[] colors = new Color[]{Color.lightGray, Color.red, Color.red, Color.orange, Color.green, Color.blue, Color.black, Color.orange, Color.yellow, Color.black, Color.yellow};
    private Color[] defaults;
    private int radius = 10;
    protected EventListenerList listenerList = new EventListenerList();
    protected final ChangeEvent changeEvent = new ChangeEvent(this);

    public GraphicsEnvironment() {
        int n = 10;
        this.defaults = new Color[n];
        for (int i = 0; i < n; ++i) {
            this.defaults[i] = new Color(Color.HSBtoRGB((float)i / (float)n, 1.0f, 1.0f));
        }
    }

    public void save(File file) throws IOException {
        FileWriter fw = new FileWriter(file, false);
        fw.write("GTP 2003 Instellingen\r\n");
        for (int i = 0; i < this.name.length; ++i) {
            fw.write(this.name[i] + "," + this.colors[i].getRed() + "-" + this.colors[i].getGreen() + "-" + this.colors[i].getBlue() + "\r\n");
        }
        fw.write("R," + this.radius + "\r\n");
        fw.close();
    }

    public void save(String name) throws IOException {
        File file = new File(name);
        this.save(file);
    }

    public void load(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException();
        }
        FileReader fr = new FileReader(file);
        char[] in = new char[21];
        int status = fr.read(in, 0, 21);
        StringBuffer sb = new StringBuffer();
        sb.append(in);
        if (!sb.toString().equals("GTP 2003 Instellingen")) {
            fr.close();
            throw new IOException(file + " (ongeldige bestandsindeling)");
        }
        while (status != -1) {
            in = new char[8];
            status = fr.read(in, 0, 8);
            sb.append(in);
        }
        fr.close();
        StringTokenizer tk = new StringTokenizer(sb.toString());
        while (tk.hasMoreTokens()) {
            Color color;
            int i;
            String token = tk.nextToken();
            StringTokenizer line = new StringTokenizer(token, ",");
            int n = line.countTokens();
            if (n != 2) continue;
            String code = line.nextToken();
            if (code.equals("R")) {
                try {
                    this.radius = Integer.parseInt(line.nextToken());
                }
                catch (Exception ex) {}
                continue;
            }
            for (i = 0; i < this.name.length && !this.name[i].equals(code); ++i) {
            }
            if (i >= this.name.length || (color = this.getColor(line.nextToken())) == null) continue;
            this.colors[i] = color;
        }
    }

    private Color getColor(String color) {
        StringTokenizer c = new StringTokenizer(color, "-");
        if (c.countTokens() == 3) {
            try {
                int r = Integer.parseInt(c.nextToken());
                int g = Integer.parseInt(c.nextToken());
                int b = Integer.parseInt(c.nextToken());
                if (r < 0 || r > 255 || b < 0 || b > 255 || g < 0 || g > 255) {
                    return null;
                }
                return new Color(r, g, b);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public void load(String name) throws IOException {
        File file = new File(name);
        this.load(file);
    }

    public Color getBackgroundColor() {
        return this.colors[0];
    }

    public void setBackgroundColor(Color color) {
        this.colors[0] = color;
        this.fireStateChanged();
    }

    public int getNodeRadius() {
        return this.radius;
    }

    public void setNodeRadius(int radius) {
        this.radius = radius;
        this.fireStateChanged();
    }

    public Color getPointColor() {
        return this.colors[1];
    }

    public void setPointColor(Color color) {
        this.colors[1] = color;
        this.fireStateChanged();
    }

    public Color getNodeColor() {
        return this.colors[9];
    }

    public void setNodeColor(Color color) {
        this.colors[9] = color;
        this.fireStateChanged();
    }

    public Color getRealNodeColor() {
        return this.colors[2];
    }

    public void setRealNodeColor(Color color) {
        this.colors[2] = color;
        this.fireStateChanged();
    }

    public Color getVirtualNodeColor() {
        return this.colors[3];
    }

    public void setVirtualNodeColor(Color color) {
        this.colors[3] = color;
        this.fireStateChanged();
    }

    public Color getCurveColor() {
        return this.colors[4];
    }

    public void setCurveColor(Color color) {
        this.colors[4] = color;
        this.fireStateChanged();
    }

    public Color getLineColor() {
        return this.colors[5];
    }

    public void setLineColor(Color color) {
        this.colors[5] = color;
        this.fireStateChanged();
    }

    public Color getSelectionColor() {
        return this.colors[6];
    }

    public void setSelectionColor(Color color) {
        this.colors[6] = color;
        this.fireStateChanged();
    }

    public void setTempColor(Color color) {
        this.colors[7] = color;
        this.fireStateChanged();
    }

    public Color getTempColor() {
        return this.colors[7];
    }

    public void setBezierColor(Color color) {
        this.colors[10] = color;
    }

    public Color getBezierColor() {
        return this.colors[10];
    }

    public Color getAxColor() {
        return this.colors[8];
    }

    public void setAxColor(Color color) {
        this.colors[8] = color;
        this.fireStateChanged();
    }

    public Color[] getDefaultColors() {
        return this.defaults;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

