/*
 * Decompiled with CFR 0.152.
 */
class Lagrange
implements Algoritme {
    private GraphicData data;
    private boolean initialized;

    public Lagrange(GraphicData data) {
        this.setData(data);
        this.initialized = true;
    }

    private Point[] neville(double startt, double endt, double step) {
        int n = this.data.getPointsCount();
        if (n == 0) {
            return null;
        }
        int aantal = (int)((endt - startt) / step + 1.0);
        Point[] results = new Point[aantal];
        double t = startt;
        for (int k = 0; k < aantal; ++k) {
            results[k] = this.calcPoint(t);
            t += step;
        }
        return results;
    }

    private Point[][] calcTriangle(double t) {
        int n = this.data.getPointsCount();
        Point[][] P = new Point[n][n];
        Point[] punt = this.data.getPoints();
        for (int i = 0; i < punt.length; ++i) {
            P[0][i] = punt[i];
        }
        Node[] nodes = this.data.getNodes();
        for (int i = 1; i <= n - 1; ++i) {
            for (int j = 0; j <= n - 1 - i; ++j) {
                double left = (nodes[i + j].getT() - t) / (nodes[i + j].getT() - nodes[j].getT());
                double x = P[i - 1][j].getX() * left + P[i - 1][j + 1].getX() * (1.0 - left);
                double y = P[i - 1][j].getY() * left + P[i - 1][j + 1].getY() * (1.0 - left);
                P[i][j] = new Point(x, y);
            }
        }
        return P;
    }

    private double[] calcGraph(double[] tab, double t) {
        int n = this.data.getNodesCount();
        int len = tab.length;
        Node[] nodes = this.data.getNodes();
        double[] nTab = new double[len + 1];
        for (int i = 0; i < len; ++i) {
            double ta = nodes[n + i - len].getT();
            double tb = nodes[i].getT();
            double noemer = ta - tb;
            double l = ta - t;
            double r = t - tb;
            if (i == 0) {
                nTab[i] = tab[i] * l / noemer;
            } else {
                int n2 = i;
                nTab[n2] = nTab[n2] + tab[i] * l / noemer;
            }
            nTab[i + 1] = tab[i] * r / noemer;
        }
        return nTab;
    }

    public void setData(GraphicData data) {
        this.data = data;
        if (!this.isValidData(data)) {
            int n = data.getPointsCount();
            data.cleanNodes();
            if (n > 0) {
                data.addNode(new Node(0.0));
            }
            if (n > 1) {
                data.addNode(new Node(1.0));
            }
            for (int i = 0; i < n - 2; ++i) {
                data.addNewNodeAndDistributeUniform();
            }
        }
        this.initialized = true;
    }

    public boolean isValidData(GraphicData data) {
        return data.getNodesCount() == data.getPointsCount() && data.isNode(0.0) && data.isNode(1.0);
    }

    public GraphicData getData() throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        return this.data;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void reset() throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        this.data = null;
        this.initialized = false;
    }

    public Point[] calculateCurve() throws NotInitializedException {
        return this.calculateCurve(0.0, 1.0);
    }

    public int[] calculateCurveX() throws NotInitializedException {
        return this.calculateCurveX(0.0, 1.0);
    }

    public int[] calculateCurveY() throws NotInitializedException {
        return this.calculateCurveY(0.0, 1.0);
    }

    public int[] calculateCurveX(double precision) throws NotInitializedException {
        double d = 1.0 / ((double)(this.data.getPointsCount() - 1) * precision);
        return this.calculateCurveX(0.0, 1.0, d);
    }

    public int[] calculateCurveY(double precision) throws NotInitializedException {
        double d = 1.0 / ((double)(this.data.getPointsCount() - 1) * precision);
        return this.calculateCurveY(0.0, 1.0, d);
    }

    public Point[] calculateCurve(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurve(start, end, d);
    }

    public int[] calculateCurveX(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurveX(start, end, d);
    }

    public int[] calculateCurveY(double start, double end) throws NotInitializedException {
        double d = 1.0 / (double)((this.data.getPointsCount() - 1) * 100);
        return this.calculateCurveY(start, end, d);
    }

    public Point[] calculateCurve(double start, double end, double precision) throws NotInitializedException {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Not Initialized data");
        }
        return this.neville(start, end, precision);
    }

    public int[] calculateCurveX(double start, double end, double precision) throws NotInitializedException {
        Point[] points = this.calculateCurve(start, end, precision);
        if (points == null) {
            return null;
        }
        return Point.getXarray(points);
    }

    public int[] calculateCurveY(double start, double end, double precision) throws NotInitializedException {
        Point[] points = this.calculateCurve(start, end, precision);
        if (points == null) {
            return null;
        }
        return Point.getYarray(points);
    }

    public void addNode(double t) {
        if (this.data.getNodesCount() == 0) {
            this.data.addPoint(new Point(0.0, 0.0));
            this.data.addNode(new Node(0.0));
            return;
        }
        Point p = this.calcPoint(t);
        Point[] points = this.data.getPoints();
        int index = 0;
        for (int i = 0; i < points.length; ++i) {
            double t2 = this.getT(points[i]);
            if (!(t2 > t)) continue;
            index = i;
            break;
        }
        this.data.insertPoint(index, p);
        this.data.addNode(new Node(t));
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        double t = node.getT();
        int index = -1;
        double minD = 1.0;
        Point[] points = this.data.getPoints();
        for (int i = 0; i < points.length; ++i) {
            double t2 = this.getT(points[i]);
            double d = Math.abs(t - t2);
            if (!(d < minD)) continue;
            minD = d;
            index = i;
        }
        if (index == -1) {
            return;
        }
        this.data.removeNode(node);
        this.data.removePoint(index);
    }

    public void halveer() {
        Node[] nodes = this.data.getNodes();
        if (nodes.length == 0) {
            return;
        }
        Node vorig = nodes[0];
        int i = 1;
        int index = 1;
        while (i < nodes.length) {
            Node volgend = nodes[i];
            double t = (volgend.getT() + vorig.getT()) / 2.0;
            Point p = this.calcPoint(t);
            Node n = new Node(t);
            this.data.addNode(n);
            this.data.insertPoint(index, p);
            vorig = volgend;
            ++i;
            index += 2;
        }
    }

    public void verdeelUniform() {
        this.data.distributeUniform();
    }

    public Point[][] tempConstruct(double t) {
        return this.calcTriangle(t);
    }

    public double[][] calcGraphs(double startt, double endt, double step) {
        int n = this.data.getNodesCount();
        int aantal = (int)((endt - startt) / step + 1.0);
        double[][] res = new double[n][aantal];
        double t = startt;
        for (int k = 0; k < aantal; ++k) {
            double[] graphs = this.calcGraph(t);
            for (int j = 0; j < n; ++j) {
                res[j][k] = graphs[j];
            }
            t += step;
        }
        return res;
    }

    public double[] calcGraph(double t) {
        int n = this.data.getNodesCount();
        double[] tab = new double[]{1.0};
        for (int i = 0; i < n - 1; ++i) {
            tab = this.calcGraph(tab, t);
        }
        return tab;
    }

    public double getT(Point p) {
        double t;
        double step = 1.0 / (double)((this.data.getPointsCount() - 1) * 1000);
        Point[] points = this.neville(0.0, 1.0, step);
        double minD = p.getDistance(points[0]);
        double minT = t = 0.0;
        int i = 1;
        while (i < points.length) {
            double d = p.getDistance(points[i]);
            if (d < minD) {
                minD = d;
                minT = t;
            }
            ++i;
            t += step;
        }
        return minT;
    }

    public void addPoint(Point p) {
        int n = this.data.getPointsCount();
        if (n == 0) {
            this.data.addNode(new Node(0.0));
        } else if (n == 1) {
            this.data.addNode(new Node(1.0));
        } else {
            this.data.addNewNodeAndDistributeUniform();
        }
        this.data.addPoint(p);
        this.data.update();
    }

    public void verdeelOpenUniform() {
    }

    public boolean isValidNodeMove(Node node, double t, double e) {
        int i;
        int k;
        Node[] nodes = this.data.getNodes();
        int n = nodes.length;
        for (k = 0; k < n && nodes[k] != node; ++k) {
        }
        if (k == n) {
            return false;
        }
        for (i = 0; i < k; ++i) {
            if (!(nodes[i].getT() > t) && !(Math.abs(nodes[i].getT() - t) <= e)) continue;
            return false;
        }
        for (i = n - 1; i > k; --i) {
            if (!(nodes[i].getT() < t) && !(Math.abs(nodes[i].getT() - t) <= e)) continue;
            return false;
        }
        return true;
    }

    public Point calcPoint(double t) {
        int n = this.data.getPointsCount();
        Point[][] p = this.calcTriangle(t);
        return p[n - 1][0];
    }
}

