/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

class NodePanel
extends JPanel
implements ChangeListener,
ActionListener,
MouseInputListener {
    private Document document;
    public static final int HULPSIZE = 10;
    private Environment environment;
    private Node selectedNode;
    private boolean changeHulpT = false;
    private Data startDragData;
    private boolean dragDataWrittenToUndoStack;
    private boolean multipleNodeSelection;
    private double originalT;
    private int searchHulpX = -1;
    private int currentX = -1;

    public NodePanel(Document document) {
        super(new BorderLayout());
        this.environment = document.getEnvironment();
        this.document = document;
        document.getData().addNodeChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(0, 50));
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public void startSearchHulpT() {
        this.searchHulpX = -1;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        this.document.paintNodesVector(g, w, h, false);
        if (this.document.getShowHulpConstructie() && this.document.getHulpT() < 0.0) {
            g.setColor(this.environment.getTempColor());
            g.drawLine(this.searchHulpX, 0, this.searchHulpX, this.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        int R;
        int x = e.getX();
        int y = e.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int yMin = h / 2 - (R = this.environment.getNodeRadius()) / 2;
        if ((y < yMin || y > yMin + R) && y > 10) {
            return;
        }
        if (y < 10) {
            this.selectedNode = null;
            double hulpT = this.document.getHulpT();
            int posT = this.getX(hulpT);
            this.changeHulpT = x >= posT - 5 && x <= posT + 5;
            return;
        }
        Node node = this.getNode(x);
        if (node == null) {
            this.selectedNode = null;
            return;
        }
        double t = node.getT();
        if (this.document.getAlgoritme() instanceof BSpline || t > 0.0 && t < 1.0) {
            double d;
            Data data = this.document.getData();
            int m = data.countNodes(this.originalT, d = (double)R / (double)(w - 20));
            if (m <= 1 && (t == 0.0 || t == 1.0)) {
                return;
            }
            this.dragDataWrittenToUndoStack = false;
            this.startDragData = (Data)data.clone();
            this.originalT = t;
            this.multipleNodeSelection = m > 1;
            this.selectedNode = node;
        } else {
            this.selectedNode = null;
        }
    }

    public void mouseReleased(MouseEvent e) {
        double t;
        int x = e.getX();
        int y = e.getY();
        int w = this.getWidth();
        int R = this.environment.getNodeRadius();
        Data data = this.document.getData();
        Algoritme algo = this.document.getAlgoritme();
        this.changeHulpT = false;
        if (this.selectedNode != null) {
            double d;
            t = this.getT(x);
            if (algo.isValidNodeMove(this.selectedNode, t, d = (double)R / (double)(w - 20)) && algo instanceof BSpline) {
                Node[] nodes = data.getNodes();
                double t2 = t;
                for (int i = 0; i < nodes.length && t == t2; ++i) {
                    if (nodes[i] == this.selectedNode || !(Math.abs(nodes[i].getT() - t) <= d)) continue;
                    t2 = nodes[i].getT();
                }
                if (t != t2) {
                    t = t2;
                }
                if (this.multipleNodeSelection) {
                    nodes = data.getNodes(this.originalT, d);
                    int res = JOptionPane.showConfirmDialog(null, "Er is meer dan \u00e9\u00e9n knoop met dezelfde t-waarde (" + t + ").\nWenst u al deze knopen te verplaatsen?", "Knopenvector", 0);
                    if (res == 0) {
                        for (int i = 0; i < nodes.length; ++i) {
                            data.moveNode(nodes[i], t);
                        }
                    }
                } else {
                    this.selectedNode = data.moveNode(this.selectedNode, t);
                }
            }
            this.selectedNode = null;
        }
        t = this.getT(x);
        if (e.isPopupTrigger() && data.getNodesCount() >= 2 && t > 0.0 && t < 1.0) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem add = new JMenuItem("Knoop toevoegen");
            add.setActionCommand("add");
            add.addActionListener(this);
            JMenuItem remove = new JMenuItem("Knoop verwijderen");
            remove.setActionCommand("remove");
            remove.addActionListener(this);
            if (algo instanceof BSpline) {
                remove.setEnabled(((BSpline)algo).canRemoveNode(t));
            }
            menu.add(add);
            if (this.getNode(x) != null) {
                menu.add(remove);
            }
            menu.addSeparator();
            JMenuItem uniform = new JMenuItem("Verdeel uniform");
            uniform.setActionCommand("uniform");
            uniform.addActionListener(this);
            JMenuItem openUniform = new JMenuItem("Verdeel open uniform");
            openUniform.setActionCommand("openuniform");
            openUniform.addActionListener(this);
            if (this.document.getAlgoritme() instanceof Lagrange) {
                openUniform.setEnabled(false);
            }
            menu.add(uniform);
            menu.add(openUniform);
            menu.addSeparator();
            JMenuItem halveer = new JMenuItem("Halveer segmenten");
            halveer.setActionCommand("halveer");
            halveer.addActionListener(this);
            menu.add(halveer);
            menu.show(this, x, y);
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int w = this.getWidth();
        int R = this.environment.getNodeRadius();
        Data data = this.document.getData();
        Algoritme algo = this.document.getAlgoritme();
        if (this.selectedNode != null) {
            double t = this.getT(x);
            double d = (double)R / (double)(w - 20);
            if (this.multipleNodeSelection || algo.isValidNodeMove(this.selectedNode, t, d)) {
                this.selectedNode = data.moveNode(this.selectedNode, t);
            }
            if (!this.dragDataWrittenToUndoStack) {
                this.dragDataWrittenToUndoStack = true;
                this.document.createUndoable(this.startDragData);
            }
            this.showToolTip(x, y);
        } else {
            double t = this.getT(x);
            int k = data.getOrder();
            Node[] nodes = data.getNodes();
            int n = nodes.length;
            if (this.changeHulpT && (algo instanceof Lagrange || t >= nodes[k - 1].getT() && t <= nodes[n - k].getT())) {
                this.document.setHulpT(t);
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.showToolTip(x, y);
        Data data = this.document.getData();
        Algoritme algo = this.document.getAlgoritme();
        Node[] nodes = data.getNodes();
        int k = data.getOrder();
        int n = nodes.length;
        double hT = this.document.getHulpT();
        double t = this.getT(x);
        if (this.document.getShowHulpConstructie() && hT < 0.0 && (algo instanceof Lagrange || t >= nodes[k - 1].getT() && t <= nodes[n - k].getT())) {
            this.searchHulpX = x;
            this.repaint();
        }
        this.currentX = x;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.document.getShowHulpConstructie() && this.document.getHulpT() < 0.0) {
            this.document.setHulpT(this.getT(x));
            this.repaint();
        }
    }

    private void showToolTip(int x, int y) {
        int R;
        int w = this.getWidth();
        int h = this.getHeight();
        int yMin = h / 2 - (R = this.environment.getNodeRadius()) / 2;
        if (y < yMin || y > yMin + R) {
            this.setToolTipText("");
            return;
        }
        Node node = this.getNode(x);
        if (node == null) {
            this.setToolTipText("");
        } else {
            double t = (double)((int)(node.getT() * 100000.0)) / 100000.0;
            this.setToolTipText(Double.toString(t));
        }
    }

    private Node getNode(int x) {
        int w = this.getWidth();
        int h = this.getHeight();
        int R = this.environment.getNodeRadius();
        double value = this.getT(x);
        double e = (double)R / (double)(w - 20);
        return this.document.getData().getNode(value, e);
    }

    private double getT(int x) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (x <= 10) {
            return 0.0;
        }
        if (x >= w - 10) {
            return 1.0;
        }
        return (double)(x - 10) / (double)(w - 20);
    }

    private int getX(double t) {
        int w = this.getWidth();
        int h = this.getHeight();
        return (int)(10.0 + (double)(w - 20) * t);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Algoritme algo = this.document.getAlgoritme();
        if (command.equals("add") && this.currentX >= 0) {
            this.document.createUndoable();
            double t = this.getT(this.currentX);
            algo.addNode(t);
            return;
        }
        if (command.equals("remove") && this.currentX >= 0) {
            this.document.createUndoable();
            Node node = this.getNode(this.currentX);
            algo.removeNode(node);
            return;
        }
        if (command.equals("halveer")) {
            this.document.halveer();
        }
        if (command.equals("uniform")) {
            this.document.verdeelUniform();
        }
        if (command.equals("openuniform")) {
            this.document.verdeelOpenUniform();
        }
    }
}

