/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OrderDialog
extends JDialog
implements ActionListener {
    protected JComboBox combo;
    protected Document document;
    protected boolean show;
    protected String label;
    protected ImageIcon icon;

    public int getValue() {
        return this.combo.getSelectedIndex() + 2;
    }

    public OrderDialog(Frame frame, Document document) {
        super(frame, "B-spline", true);
        this.document = document;
        this.label = "Kies de graad voor de curve";
        this.icon = new ImageIcon("bspline2.gif");
        this.setupContentPane();
        this.setLocationRelativeTo(frame);
    }

    public OrderDialog(Dialog dialog, Document document) {
        super(dialog, "B-spline", true);
        this.document = document;
        this.label = "Kies de graad voor de curve";
        this.icon = new ImageIcon("bspline2.gif");
        this.setupContentPane();
        this.setLocationRelativeTo(dialog);
    }

    public void actionPerformed(ActionEvent e) {
        this.show = false;
        this.setVisible(false);
    }

    private void setupContentPane() {
        this.combo = new JComboBox();
        Data data = this.document.getData();
        for (int i = 2; i <= data.getPointsCount(); ++i) {
            this.combo.addItem(new Integer(i));
        }
        int k = data.getOrder();
        if (k > 1) {
            this.combo.setSelectedIndex(k - 2);
        }
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(this);
        this.getRootPane().setDefaultButton(btnOK);
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 1;
        JLabel lblDistance = new JLabel(this.label);
        gbl.setConstraints(lblDistance, gbc);
        panel.add(lblDistance);
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbl.setConstraints(this.combo, gbc);
        panel.add(this.combo);
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(btnOK);
        gbl.setConstraints(buttonPanel, gbc);
        panel.add(buttonPanel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 20, 5, 20);
        gbc.gridheight = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        JLabel lblIcon = new JLabel(this.icon);
        gbl.setConstraints(lblIcon, gbc);
        panel.add(lblIcon);
        this.setContentPane(panel);
        this.pack();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.show;
    }
}

