/*
 * Decompiled with CFR 0.152.
 */
class Point {
    private double x;
    private double y;
    private double weight;

    public Point(double x, double y) {
        this.set(x, y);
    }

    public Object clone() {
        return new Point(this.x, this.y, this.weight);
    }

    public Point(double x, double y, double weight) {
        this.set(x, y);
        this.weight = weight;
    }

    public Point() {
        this.set(0.0, 0.0);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void set(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public void set(Point p) {
        this.setX(p.getX());
        this.setY(p.getY());
    }

    public double getDistance(Point point) {
        return Math.sqrt((this.x - point.getX()) * (this.x - point.getX()) + (this.y - point.getY()) * (this.y - point.getY()));
    }

    public double getDistance(double x, double y) {
        return this.getDistance(new Point(x, y));
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    public static int[] getXarray(Point[] p) {
        int[] res = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            res[i] = (int)p[i].getX();
        }
        return res;
    }

    public static int[] getYarray(Point[] p) {
        int[] res = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            res[i] = (int)p[i].getY();
        }
        return res;
    }
}

