/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PropertiesPanel
extends JPanel
implements ActionListener {
    private JButton okbtn;
    private JButton defaultbtn;
    private JButton applybtn;
    private Environment environ;
    private ColorPanel backgroundPanel;
    private ColorPanel curvePanel;
    private ColorPanel linePanel;
    private ColorPanel pointPanel;
    private ColorPanel selectionPanel;
    private ColorPanel realPanel;
    private ColorPanel virtualPanel;
    private ColorPanel axPanel;
    private ColorPanel tempPanel;
    private ColorPanel nodePanel;
    private ColorPanel bezierPanel;
    private JComboBox combo;
    private PropertiesDialog dialog;

    public PropertiesPanel(Environment environ, PropertiesDialog dialog) {
        this.environ = environ;
        this.dialog = dialog;
        this.setup();
        this.addAll();
        this.okbtn = new JButton("OK");
        this.okbtn.setActionCommand("ok");
        this.defaultbtn = new JButton("Standaard");
        this.defaultbtn.setActionCommand("default");
        this.applybtn = new JButton("Toepassen");
        this.applybtn.setActionCommand("apply");
        this.okbtn.addActionListener(this);
        this.defaultbtn.addActionListener(this);
        this.applybtn.addActionListener(this);
        this.add(this.okbtn);
        this.add(this.defaultbtn);
        this.add(this.applybtn);
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("ok")) {
            this.modify();
            this.dialog.closeDialog();
        } else if (str.equals("default")) {
            this.setupDefault();
            this.repaint();
        }
        if (str.equals("apply")) {
            this.modify();
        }
    }

    private void setup() {
        this.combo = new JComboBox();
        this.combo.addItem(new String("5"));
        this.combo.addItem(new String("10"));
        this.combo.addItem(new String("15"));
        this.combo.addItem(new String("20"));
        this.combo.addItem(new String("25"));
        this.combo.addItem(new String("30"));
        this.combo.setSelectedIndex(this.environ.getNodeRadius() / 5 - 1);
        this.backgroundPanel = new ColorPanel("Achtergrond", this.environ.getBackgroundColor());
        this.pointPanel = new ColorPanel("Punten", this.environ.getPointColor());
        this.selectionPanel = new ColorPanel("Geselecteerd punt", this.environ.getSelectionColor());
        this.realPanel = new ColorPanel("Reele knopen", this.environ.getRealNodeColor());
        this.virtualPanel = new ColorPanel("Virtuele knopen", this.environ.getVirtualNodeColor());
        this.nodePanel = new ColorPanel("Weergave knopen", this.environ.getNodeColor());
        this.curvePanel = new ColorPanel("Curve", this.environ.getCurveColor());
        this.linePanel = new ColorPanel("Verbindingslijnen", this.environ.getLineColor());
        this.tempPanel = new ColorPanel("Hulpconstructie", this.environ.getTempColor());
        this.axPanel = new ColorPanel("Assen", this.environ.getAxColor());
        this.bezierPanel = new ColorPanel("B\u00e9zier representatie", this.environ.getBezierColor());
    }

    private void setupDefault() {
        GraphicsEnvironment e = new GraphicsEnvironment();
        this.combo.setSelectedIndex(e.getNodeRadius() / 5 - 1);
        this.backgroundPanel.setColor(e.getBackgroundColor());
        this.pointPanel.setColor(e.getPointColor());
        this.selectionPanel.setColor(e.getSelectionColor());
        this.realPanel.setColor(e.getRealNodeColor());
        this.virtualPanel.setColor(e.getVirtualNodeColor());
        this.nodePanel.setColor(e.getNodeColor());
        this.curvePanel.setColor(e.getCurveColor());
        this.linePanel.setColor(e.getLineColor());
        this.tempPanel.setColor(e.getTempColor());
        this.axPanel.setColor(e.getAxColor());
        this.bezierPanel.setColor(this.environ.getBezierColor());
    }

    private void addAll() {
        this.add(new JLabel("Straal punten/knopen:"));
        this.add(this.combo);
        this.add(this.pointPanel);
        this.add(this.selectionPanel);
        this.add(this.linePanel);
        this.add(this.curvePanel);
        this.add(this.realPanel);
        this.add(this.virtualPanel);
        this.add(this.nodePanel);
        this.add(this.tempPanel);
        this.add(this.bezierPanel);
        this.add(this.backgroundPanel);
        this.add(this.axPanel);
    }

    public void modify() {
        this.environ.setNodeRadius(this.combo.getSelectedIndex() * 5 + 5);
        this.environ.setBackgroundColor(this.backgroundPanel.getColor());
        this.environ.setCurveColor(this.curvePanel.getColor());
        this.environ.setLineColor(this.linePanel.getColor());
        this.environ.setPointColor(this.pointPanel.getColor());
        this.environ.setRealNodeColor(this.realPanel.getColor());
        this.environ.setVirtualNodeColor(this.virtualPanel.getColor());
        this.environ.setAxColor(this.axPanel.getColor());
        this.environ.setTempColor(this.tempPanel.getColor());
        this.environ.setSelectionColor(this.selectionPanel.getColor());
        this.environ.setNodeColor(this.nodePanel.getColor());
    }
}

