/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.EnhancedAbstractAction;
import config.OptionAnnotation;
import config.OptionListener;
import config.OptionModel;
import java.lang.reflect.Method;

public abstract class AbstractOptionAction
extends EnhancedAbstractAction
implements OptionListener {
    protected OptionAnnotation annotation;
    protected OptionModel model;
    protected Method getter;
    protected Method setter;

    public AbstractOptionAction(OptionAnnotation annotation, OptionModel model, Class argument) {
        super(annotation.name());
        this.annotation = annotation;
        this.model = model;
        try {
            this.getter = model.getClass().getMethod(annotation.getter(), null);
            this.setter = model.getClass().getMethod(annotation.setter(), argument);
        }
        catch (Exception e) {
            // empty catch block
        }
        model.addOptionListener(this);
    }

    public OptionModel getModel() {
        return this.model;
    }

    public Object getValue() {
        try {
            return this.getter.invoke((Object)this.model, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setValue(Object value) {
        try {
            this.setter.invoke((Object)this.model, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void optionChanged(OptionModel optionModel) {
    }

    public OptionAnnotation getAnnotation() {
        return this.annotation;
    }
}

