/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.AbstractOptionAction;
import config.OptionAnnotation;
import config.OptionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;

public class ColorOptionAction
extends AbstractOptionAction {
    public ColorOptionAction(OptionAnnotation annotation, OptionModel model) {
        super(annotation, model, Color.class);
        this.optionChanged(model);
    }

    public void optionChanged(OptionModel optionModel) {
        this.setIcon(new SquareIcon(8));
    }

    public void actionPerformed(ActionEvent e) {
        Color color = (Color)this.getValue();
        Color newcolor = JColorChooser.showDialog(null, "Kies een kleur", color);
        if (newcolor == null) {
            return;
        }
        this.setValue(newcolor);
        color = newcolor;
    }

    private class SquareIcon
    implements Icon {
        private int size;

        public SquareIcon(int size) {
            this.size = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color backup = g.getColor();
            g.setColor((Color)ColorOptionAction.this.getValue());
            g.fillRect(x, y, this.size, this.size);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, this.size, this.size);
            g.setColor(backup);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }
}

