/*
 * Decompiled with CFR 0.152.
 */
package actions;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class EnhancedAbstractAction
extends AbstractAction {
    public EnhancedAbstractAction(String title, Icon icon) {
        super(title, icon);
        this.setDefaultMnemonic(title);
    }

    public EnhancedAbstractAction(String title) {
        super(title);
        this.setDefaultMnemonic(title);
    }

    public EnhancedAbstractAction() {
    }

    private void setDefaultMnemonic(String title) {
        if (!title.equals("")) {
            this.putValue("MnemonicKey", new Integer(title.charAt(0) - 65 + 65));
        }
    }

    protected void setMnemonic(char mnemonic) {
        this.putValue("MnemonicKey", new Integer(mnemonic));
    }

    protected void setAccelerator(String key) {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key));
    }

    protected void setShortDescription(String description) {
        this.putValue("ShortDescription", description);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public static void setDefaultMnemonic(AbstractButton button) {
        if (button.getText().length() > 0) {
            button.setMnemonic(button.getText().charAt(0));
        }
    }
}

