/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.EnhancedAbstractAction;
import gui.CurveViewPanel;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportCurveToPNGAction
extends EnhancedAbstractAction {
    private JFileChooser chooser;
    private CurveViewPanel panel;

    public ExportCurveToPNGAction(CurveViewPanel p) {
        super("Exporteer naar PNG...");
        this.panel = p;
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File("."));
        this.chooser.setFileFilter(new ExtensionFilter(".png"));
    }

    public void actionPerformed(ActionEvent e) {
        Object[] opties;
        int answer;
        if (this.chooser.showDialog(this.panel, "Curve exporteren naar PNG") != 0) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        if (!file.getPath().endsWith(".png")) {
            file = new File(file.getPath() + ".png");
        }
        if (file.exists() && (answer = JOptionPane.showOptionDialog(this.panel, "Dit bestand bestaat al. Wil je dit bestand overschrijven?", "Waarschuwing", -1, 3, null, opties = new String[]{"Ja", "Neen"}, opties[1])) != 0) {
            return;
        }
        this.exportToPNGFile(file);
    }

    public void exportToPNGFile(File file) {
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            writer.setOutput(ios);
            BufferedImage image = new BufferedImage(this.panel.getWidth(), this.panel.getHeight(), 2);
            this.panel.paintComponent(image.createGraphics());
            writer.write(image);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.panel, "Fout bij het exporteren naar png file!\n" + e.getMessage());
        }
    }

    private class ExtensionFilter
    extends FileFilter {
        private String extension;

        public ExtensionFilter(String ext) {
            this.extension = ext;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getPath().endsWith(this.extension);
        }

        public String getDescription() {
            return "*" + this.extension;
        }
    }
}

