/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.EnhancedAbstractAction;
import curve.CurveModel;
import gui.CurveViewPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LoadCurveAction
extends EnhancedAbstractAction {
    private JFileChooser chooser;
    private CurveModel model;
    private CurveViewPanel panel;

    public LoadCurveAction(CurveViewPanel p, CurveModel m) {
        super("Laad curve in...");
        this.model = m;
        this.panel = p;
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File("."));
        this.chooser.setFileFilter(new ExtensionFilter(".curve"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.chooser.showDialog(this.panel, "Curve inladen") != 0) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        try {
            this.model.readFromFile(file.getCanonicalPath());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Fout bij het openen van de curve!\n" + ex.getMessage());
        }
    }

    private class ExtensionFilter
    extends FileFilter {
        private String extension;

        public ExtensionFilter(String ext) {
            this.extension = ext;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getPath().endsWith(this.extension);
        }

        public String getDescription() {
            return "*" + this.extension;
        }
    }
}

