/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.EnhancedAbstractAction;
import curve.CurveModel;
import gui.CurveViewPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SaveCurveAction
extends EnhancedAbstractAction {
    private JFileChooser chooser;
    private CurveModel model;
    private CurveViewPanel panel;

    public SaveCurveAction(CurveViewPanel p, CurveModel m) {
        super("Sla de huidige curve op...");
        this.model = m;
        this.panel = p;
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File("."));
        this.chooser.setFileFilter(new ExtensionFilter(".curve"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.chooser.showDialog(this.panel, "Curve opslaan") != 0) {
            return;
        }
        File file = this.chooser.getSelectedFile();
        if (!file.getPath().endsWith(".curve")) {
            file = new File(file.getPath() + ".curve");
        }
        try {
            Object[] opties;
            int answer;
            if (file.exists() && (answer = JOptionPane.showOptionDialog(this.panel, "Dit bestand bestaat al. Wil je dit bestand overschrijven?", "Waarschuwing", -1, 3, null, opties = new String[]{"Ja", "Neen"}, opties[1])) != 0) {
                return;
            }
            this.model.writeToFile(file.getCanonicalPath());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.panel, "Fout bij het opslaan van de curve!\n" + ex.getMessage());
        }
    }

    private class ExtensionFilter
    extends FileFilter {
        private String extension;

        public ExtensionFilter(String ext) {
            this.extension = ext;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getPath().endsWith(this.extension);
        }

        public String getDescription() {
            return "*" + this.extension;
        }
    }
}

