/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.OptionAnnotation;
import config.OptionListener;
import curve.CurveModel;
import gui.DefaultPointRenderer;
import gui.PointRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.Set;

public class OptionModel {
    public static final Float LINE_SMALL = new Float(1.0f);
    public static final Float LINE_NORMAL = new Float(2.0f);
    public static final Float LINE_BIG = new Float(3.0f);
    public static final String LINE_SMALL_STRING = "SMALL";
    public static final String LINE_NORMAL_STRING = "NORMAL";
    public static final String LINE_BIG_STRING = "BIG";
    private Set<OptionListener> listenerSet = new HashSet<OptionListener>();
    private CurveModel selectedCurve;
    private static final PointRenderer pointRenderer = new DefaultPointRenderer();
    private Color gridColor = Color.LIGHT_GRAY;
    private Color panelColor = new Color(238, 238, 238);
    private boolean enablePolygon = true;
    private boolean enableDrawPoints = true;
    private boolean drawCurvePoints;
    private boolean enableAA = true;
    private Float highLightWidth;
    private Float curveWidth;

    public void addOptionListener(OptionListener l) {
        this.listenerSet.add(l);
    }

    public void removeOptionListener(OptionListener l) {
        this.listenerSet.remove(l);
    }

    protected void fireOptionChanged() {
        for (OptionListener listener : this.listenerSet) {
            listener.optionChanged(this);
        }
    }

    public OptionModel(CurveModel selectedCurve) {
        this.selectedCurve = selectedCurve;
        this.drawCurvePoints = false;
        this.highLightWidth = LINE_NORMAL;
        this.curveWidth = LINE_SMALL;
    }

    public Stroke getCurveStroke(CurveModel curveModel) {
        return new BasicStroke(this.curveWidth.floatValue());
    }

    public PointRenderer getPointRenderer() {
        return pointRenderer;
    }

    public Stroke getGridStroke() {
        return new BasicStroke();
    }

    public Color getCurveColor() {
        return this.selectedCurve.getCurveColor();
    }

    @OptionAnnotation(name="Curvekleur...", type=OptionType.COLOR, getter="getCurveColor", setter="setCurveColor", group="Colors")
    public void setCurveColor(Color curvecolor) {
        this.selectedCurve.setCurveColor(curvecolor);
        this.fireOptionChanged();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    @OptionAnnotation(name="Gridkleur...", type=OptionType.COLOR, getter="getGridColor", setter="setGridColor", group="Colors")
    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
        this.fireOptionChanged();
    }

    public Color getPanelColor() {
        return this.panelColor;
    }

    @OptionAnnotation(name="Paneelkleur...", type=OptionType.COLOR, getter="getPanelColor", setter="setPanelColor", group="Colors")
    public void setPanelColor(Color panelColor) {
        this.panelColor = panelColor;
        this.fireOptionChanged();
    }

    public Stroke getPolygonStroke() {
        float[] dash = new float[]{10.0f, 10.0f};
        return new BasicStroke(1.0f, 2, 2, 1.0f, dash, 0.0f);
    }

    public Paint getPolygonPaint() {
        return Color.RED.darker();
    }

    public Boolean isPolygonEnabled() {
        return this.enablePolygon;
    }

    @OptionAnnotation(name="Teken controleveelhoek", type=OptionType.BOOLEAN, getter="isPolygonEnabled", setter="setPolygonEnabled", group="Drawing")
    public void setPolygonEnabled(Boolean enablePolygon) {
        this.enablePolygon = enablePolygon;
        this.fireOptionChanged();
    }

    public Boolean isDrawPointsEnabled() {
        return this.enableDrawPoints;
    }

    @OptionAnnotation(name="Teken punten", type=OptionType.BOOLEAN, getter="isDrawPointsEnabled", setter="setDrawPointsEnabled", group="Drawing")
    public void setDrawPointsEnabled(Boolean enableDrawPoints) {
        this.enableDrawPoints = enableDrawPoints;
        this.fireOptionChanged();
    }

    public boolean getDrawCurvePoints() {
        return this.drawCurvePoints;
    }

    @OptionAnnotation(name="Teken curvepunten", type=OptionType.BOOLEAN, getter="getDrawCurvePoints", setter="setDrawCurvePoints", group="Drawing")
    public void setDrawCurvePoints(Boolean set) {
        this.drawCurvePoints = set;
        this.fireOptionChanged();
    }

    public Boolean isAAEnabled() {
        return this.enableAA;
    }

    @OptionAnnotation(name="Anti-alias", type=OptionType.BOOLEAN, getter="isAAEnabled", setter="setEnableAA")
    public void setEnableAA(Boolean enableAA) {
        this.enableAA = enableAA;
        this.fireOptionChanged();
    }

    public Float getHighLightWidth() {
        return this.highLightWidth;
    }

    @OptionAnnotation(name="Dikte veranderingskromme", type=OptionType.LINEWIDTH, getter="getHighLightWidth", setter="setHighLightWidth", group="Lines")
    public void setHighLightWidth(Float set) {
        this.highLightWidth = set;
        this.fireOptionChanged();
    }

    public Float getCurveWidth() {
        return this.curveWidth;
    }

    @OptionAnnotation(name="Dikte kromme", type=OptionType.LINEWIDTH, getter="getCurveWidth", setter="setCurveWidth", group="Lines")
    public void setCurveWidth(Float set) {
        this.curveWidth = set;
        this.fireOptionChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionType {
        COLOR,
        BOOLEAN,
        LINEWIDTH,
        SPECIAL;

    }
}

