/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.ControlPoint;
import curve.CurveModel;
import curve.CurvePoint;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularList
implements Iterable<CurvePoint> {
    private CurvePoint[] list;
    private int size;

    public CircularList(int maxSize) {
        this.list = new CurvePoint[maxSize];
        this.size = 0;
    }

    public CircularList(CurvePoint[] list) {
        this.list = list;
        this.size = list.length;
    }

    public CircularList(List<ControlPoint> curvePointList) {
        this(curvePointList.toArray(new CurvePoint[0]));
    }

    public int size() {
        return this.size;
    }

    public int getMaxSize() {
        return this.list.length;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public CurvePoint get(int index) {
        int res = index % this.size;
        if (res < 0) {
            res += this.size;
        }
        return this.list[res];
    }

    public CurvePoint first() {
        if (this.size > 0) {
            return this.list[0];
        }
        return null;
    }

    public CurvePoint last() {
        if (this.size > 0) {
            return this.list[this.size - 1];
        }
        return null;
    }

    public void set(int index, CurvePoint point) {
        int res = index % this.size;
        if (res < 0) {
            res += this.size;
        }
        this.list[res] = point;
    }

    public void doubleList() {
        int oldSize = this.size();
        this.setSize(oldSize * 2);
        int pointer2 = 2 * oldSize - 1;
        for (int pointer = oldSize - 1; pointer >= 0; --pointer) {
            this.list[pointer2--] = this.list[pointer];
            this.list[pointer2--] = this.list[pointer];
        }
    }

    public CurvePoint[] toArray() {
        CurvePoint[] array = new CurvePoint[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.list[i];
        }
        return array;
    }

    public int getLeftInfluencedPoint(CurveModel curveModel, int pointNr) {
        int it = curveModel.getIterations();
        int gr = curveModel.getGrade();
        if (!curveModel.getCurveMode()) {
            int left = (int)Math.pow(2.0, it) * (pointNr + 1 - (gr + 1)) + gr - 1;
            return left > 0 ? left : 0;
        }
        int left = (int)Math.pow(2.0, it) * (pointNr - gr) + gr - 1;
        return left;
    }

    public int getRightInfluencedPoint(CurveModel curveModel, int pointNr) {
        int it = curveModel.getIterations();
        int gr = curveModel.getGrade();
        if (!curveModel.getCurveMode()) {
            int right = (int)Math.pow(2.0, it) * (pointNr + 1) + 1;
            return right < this.size ? right : this.size;
        }
        int right = (int)Math.pow(2.0, it) * (pointNr + 1) + 1;
        return right;
    }

    @Override
    public Iterator<CurvePoint> iterator() {
        return new CircularListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CircularListIterator
    implements Iterator<CurvePoint> {
        private int index = 0;

        @Override
        public CurvePoint next() {
            return CircularList.this.list[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < CircularList.this.size;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

