/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.CurveModel;
import curve.CurvePoint;

public class ControlPoint
extends CurvePoint {
    protected CurveModel model;
    protected boolean selected;
    protected int label;

    public ControlPoint(double x, double y) {
        super(x, y);
    }

    public ControlPoint(double x, double y, double z) {
        super(x, y, z);
    }

    public void setCurveModel(CurveModel model) {
        this.model = model;
    }

    private void fireCurveChanged(String msg) {
        if (this.model != null) {
            this.model.fireCurveChanged(this.model.ADJ_CURVE);
        }
    }

    public double distance(ControlPoint point) {
        return Math.sqrt((this.getHomX() - point.getHomX()) * (this.getHomX() - point.getHomX()) + (this.getHomY() - point.getHomY()) * (this.getHomY() - point.getHomY()));
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setFactor(double factor) {
        if (factor == 0.0) {
            return;
        }
        double newX = this.getHomX();
        double newY = this.getHomY();
        this.x = newX * factor;
        this.y = newY * factor;
        this.z = factor;
        this.fireCurveChanged("setFactor");
    }

    public double getFactor() {
        return this.z;
    }

    public void copy(ControlPoint point) {
        this.x = point.getHomX() * this.z;
        this.y = point.getHomY() * this.z;
        this.fireCurveChanged("copy from point");
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int label) {
        this.label = label;
    }
}

