/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.CurveModel;

public class CurveEvent {
    private boolean pointAdded;
    private boolean pointRemoved;
    private boolean shapeChanged;
    private boolean configurationChanged;
    private CurveModel curveModel;

    protected CurveEvent(CurveModel curveModel, boolean pointAdded, boolean pointRemoved, boolean shapeChanged, boolean configurationChanged) {
        this.curveModel = curveModel;
        this.pointAdded = pointAdded;
        this.pointRemoved = pointRemoved;
        this.shapeChanged = shapeChanged;
        this.configurationChanged = configurationChanged;
    }

    public CurveModel getSource() {
        return this.curveModel;
    }

    public boolean isNrOfPointsChanged() {
        return this.pointAdded || this.pointRemoved;
    }

    public boolean isPointAdded() {
        return this.pointAdded;
    }

    public boolean isPointRemoved() {
        return this.pointRemoved;
    }

    public boolean isShapeChanged() {
        return this.shapeChanged;
    }

    public boolean isConfigurationChanged() {
        return this.configurationChanged;
    }

    public static CurveEvent getPointAddedEvent(CurveModel source) {
        return new CurveEvent(source, true, false, true, false);
    }

    public static CurveEvent getPointRemovedEvent(CurveModel source) {
        return new CurveEvent(source, false, true, true, false);
    }

    public static CurveEvent getCurveAdjustedEvent(CurveModel source) {
        return new CurveEvent(source, false, false, true, false);
    }

    public static CurveEvent getConfigurationEvent(CurveModel source) {
        return new CurveEvent(source, false, false, true, true);
    }

    public static CurveEvent getRotateEvent(CurveModel source) {
        return new CurveEvent(source, false, false, true, false);
    }

    public static CurveEvent getFullEvent(CurveModel source) {
        return new CurveEvent(source, true, true, true, true);
    }
}

