/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.ControlPoint;
import curve.CurveModel;
import curve.CurveSelectionListener;
import gui.GridListener;
import gui.GridModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveList
implements Iterable<CurveModel>,
GridListener {
    private Set<CurveSelectionListener> listenerSet = new HashSet<CurveSelectionListener>();
    private static final ControlPoint NO_SELECTION = null;
    private CurveModel selectedCurveModel;
    private GridModel gridModel;
    private List<CurveModel> curveList;
    private int selectedCurveIndex;
    private int curveCounter = 0;
    private Color[] curveColors = new Color[]{Color.GREEN.darker(), Color.RED, Color.CYAN, Color.ORANGE, Color.BLUE, Color.BLACK};
    private int colorIndex = 0;

    public void addCurveSelectionListener(CurveSelectionListener l) {
        this.listenerSet.add(l);
    }

    public void removeCurveSelectionListener(CurveSelectionListener l) {
        this.listenerSet.remove(l);
    }

    protected void fireSelectionChanged() {
        for (CurveSelectionListener listener : this.listenerSet) {
            listener.selectionChanged(this);
        }
    }

    public CurveList(CurveModel selectedCurveModel) {
        this.selectedCurveModel = selectedCurveModel;
        selectedCurveModel.setCurveColor(this.nextColor());
        selectedCurveModel.setLabel(this.nextLabel());
        this.curveList = new ArrayList<CurveModel>();
        this.curveList.add(new CurveModel(selectedCurveModel));
        this.selectedCurveIndex = 0;
        this.syncSelected();
    }

    private Color nextColor() {
        Color color = this.curveColors[this.colorIndex];
        this.colorIndex = (this.colorIndex + 1) % this.curveColors.length;
        return color;
    }

    private String nextLabel() {
        ++this.curveCounter;
        return "curve " + this.curveCounter;
    }

    private void syncSelected() {
        this.curveList.get(this.selectedCurveIndex).copy(this.selectedCurveModel);
    }

    public CurveModel getSelectedCurve() {
        return this.selectedCurveModel;
    }

    @Override
    public Iterator<CurveModel> iterator() {
        return new CurveIterator();
    }

    public CurveModel getSelectedCurveModel() {
        return this.selectedCurveModel;
    }

    public boolean isSelected(CurveModel curveModel) {
        return this.selectedCurveModel.equals(curveModel);
    }

    public int nrOfCurves() {
        return this.curveList.size();
    }

    public CurveModel getCurve(int index) {
        return index == this.selectedCurveIndex ? this.selectedCurveModel : this.curveList.get(index);
    }

    public void setCurve(int index) {
        if (index != this.selectedCurveIndex) {
            this.syncSelected();
            this.selectedCurveIndex = index;
            this.selectedCurveModel.copy(this.curveList.get(index));
        }
    }

    public void newCurve() {
        CurveModel newCurve = new CurveModel(this.selectedCurveModel.getCurveApproximator());
        newCurve.setCurveColor(this.nextColor());
        ++this.curveCounter;
        newCurve.setLabel("curve " + this.curveCounter);
        this.curveList.add(newCurve);
        this.setCurve(this.curveList.size() - 1);
        this.fireSelectionChanged();
    }

    public void removeSelectedCurve() {
        if (this.curveList.size() > 1) {
            this.curveList.remove(this.selectedCurveIndex);
            this.selectedCurveIndex = 0;
            this.selectedCurveModel.copy(this.curveList.get(0));
            this.fireSelectionChanged();
        }
    }

    public GridModel getGridModel() {
        return this.gridModel;
    }

    public void setGridModel(GridModel newGridModel) {
        if (this.gridModel != null) {
            this.gridModel.removeGridListener(this);
        }
        this.gridModel = newGridModel;
        if (newGridModel != null) {
            newGridModel.addGridListener(this);
        }
        this.selectedCurveModel.setGridModel(newGridModel);
    }

    @Override
    public void gridChanged(GridModel gridModel) {
        if (gridModel.isSnapToGrid()) {
            for (CurveModel curve : this) {
                curve.snapToGrid(gridModel);
            }
            this.selectedCurveModel.fireChanged(this.selectedCurveModel.FULL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurveIterator
    implements Iterator<CurveModel> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < CurveList.this.curveList.size();
        }

        @Override
        public CurveModel next() {
            int prevIndex;
            return (prevIndex = this.index++) == CurveList.this.selectedCurveIndex ? CurveList.this.selectedCurveModel : (CurveModel)CurveList.this.curveList.get(prevIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

