/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.CircularList;
import curve.ControlPoint;
import curve.CurveApproximator;
import curve.CurveEvent;
import curve.CurveListener;
import curve.CurvePoint;
import gui.GridModel;
import gui.PointSelectionModel;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveModel
implements Iterable<ControlPoint> {
    private Set<CurveListener> listenerSet = new HashSet<CurveListener>();
    private boolean updateListeners = true;
    public final CurveEvent ADD_POINT = CurveEvent.getPointAddedEvent(this);
    public final CurveEvent DEL_POINT = CurveEvent.getPointRemovedEvent(this);
    public final CurveEvent ADJ_CURVE = CurveEvent.getCurveAdjustedEvent(this);
    public final CurveEvent CONFIG = CurveEvent.getConfigurationEvent(this);
    public final CurveEvent ROTATE = CurveEvent.getRotateEvent(this);
    public final CurveEvent FULL = CurveEvent.getFullEvent(this);
    private static final int DEFAULT_ITERATIONS = 3;
    private static final int DEFAULT_GRADE = 3;
    private static final int MAX_ITERATIONS = 10;
    public static final boolean OPEN = false;
    public static final boolean CLOSED = true;
    private int iterations;
    private int grade;
    private List<ControlPoint> controlPointList;
    private CurveApproximator curveApproximator;
    private PointSelectionModel selectionModel;
    private CircularList curvePoints;
    private boolean curveMode;
    private GridModel gridModel;
    private double angle;
    private Color curveColor = Color.GREEN;
    private String label = "curve";

    public void addCurveListener(CurveListener l) {
        this.listenerSet.add(l);
    }

    public void removeCurveListener(CurveListener l) {
        this.listenerSet.remove(l);
    }

    public void fireCurveChanged(CurveEvent event) {
        if (this.updateListeners) {
            this.curvePoints = this.curveApproximator.approxCurve(this.grade, this.iterations, this.curveMode, this.controlPointList, this.curvePoints);
            this.fireChanged(event);
        }
    }

    public void fireChanged(CurveEvent event) {
        if (this.updateListeners) {
            for (CurveListener listener : this.listenerSet) {
                listener.curveChanged(event);
            }
        }
    }

    public CurveModel(CurveApproximator curveApproximator, int grade, int iterations) {
        this.curveApproximator = curveApproximator;
        this.grade = grade;
        this.iterations = iterations;
        this.curveMode = false;
        this.selectionModel = new PointSelectionModel();
        this.curvePoints = new CircularList(0);
        this.controlPointList = new LinkedList<ControlPoint>();
        this.gridModel = new GridModel();
    }

    public CurveModel(CurveApproximator curveApproximator) {
        this(curveApproximator, 3, 3);
    }

    public CurveModel(CurveModel copyModel) {
        this.copy(copyModel);
        this.selectionModel = new PointSelectionModel();
    }

    public void setIterations(int iterations) {
        if (iterations > 0 && iterations <= 10) {
            this.iterations = iterations;
        }
        this.fireCurveChanged(this.CONFIG);
    }

    public void setGrade(int grade) {
        this.grade = grade;
        this.fireCurveChanged(this.CONFIG);
    }

    public void rotate(double angle, CurvePoint center) {
        if (angle != 0.0) {
            for (ControlPoint p : this) {
                double x = p.getHomX();
                double y = p.getHomY();
                double t1 = -center.getHomX() * Math.cos(angle) + center.getHomY() * Math.sin(angle) + center.getHomX();
                double t2 = -center.getHomX() * Math.sin(angle) - center.getHomY() * Math.cos(angle) + center.getHomY();
                double rotX = Math.cos(angle) * x - Math.sin(angle) * y + t1;
                double rotY = Math.sin(angle) * x + Math.cos(angle) * y + t2;
                p.setHomX(rotX);
                p.setHomY(rotY);
            }
        }
        this.fireCurveChanged(this.ROTATE);
    }

    public void setCurveApproximator(CurveApproximator curveApproximator) {
        this.curveApproximator = curveApproximator;
    }

    public CurveApproximator getCurveApproximator() {
        return this.curveApproximator;
    }

    public void addControlPoint(ControlPoint point) {
        if (!this.curveMode) {
            if (this.gridModel.isSnapToGrid()) {
                point = this.gridModel.snapPointToGrid(point);
            }
            point.setCurveModel(this);
            point.setLabel(this.getNrOfPoints());
            this.controlPointList.add(point);
            this.fireCurveChanged(this.ADD_POINT);
        }
    }

    public void removeLastPoint() {
        if (this.controlPointList.size() > 0) {
            this.controlPointList.remove(this.controlPointList.size() - 1);
            this.curveMode = false;
            this.fireCurveChanged(this.DEL_POINT);
        }
    }

    public ControlPoint locateClosestPoint(ControlPoint comparePoint, double maxDistance) {
        double distance = 2.0 * maxDistance;
        ControlPoint closestPoint = null;
        for (ControlPoint point : this) {
            double newDistance = comparePoint.distance(point);
            if (!(newDistance < distance)) continue;
            distance = newDistance;
            closestPoint = point;
        }
        return distance <= maxDistance ? closestPoint : null;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setCurveMode(boolean curveMode) {
        this.curveMode = curveMode;
        this.fireCurveChanged(this.CONFIG);
    }

    public boolean getCurveMode() {
        return this.curveMode;
    }

    public boolean canDecrGrade() {
        return this.grade > 1;
    }

    public boolean canDecrIterations() {
        return this.iterations > 1;
    }

    public void incrGrade() {
        this.setGrade(this.grade + 1);
    }

    public void decrGrade() {
        if (this.canDecrGrade()) {
            this.setGrade(this.grade - 1);
        }
    }

    public void incrIterations() {
        this.setIterations(this.iterations + 1);
    }

    public void decrIterations() {
        if (this.canDecrIterations()) {
            this.setIterations(this.iterations - 1);
        }
    }

    public void toggleCurveMode() {
        this.setCurveMode(!this.curveMode);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void clearCurve() {
        this.controlPointList.clear();
        this.curveMode = false;
        this.fireCurveChanged(this.FULL);
    }

    @Override
    public Iterator<ControlPoint> iterator() {
        return this.controlPointList.iterator();
    }

    public CircularList approxCurve() {
        return this.curvePoints;
    }

    public void setCurveColor(Color curveColor) {
        this.curveColor = curveColor;
    }

    public Color getCurveColor() {
        return this.curveColor;
    }

    public int getNrOfPoints() {
        return this.controlPointList.size();
    }

    public PointSelectionModel getPointSelectionModel() {
        return this.selectionModel;
    }

    public void setGridModel(GridModel gridModel) {
        this.gridModel = gridModel;
    }

    public GridModel getGridModel() {
        return this.gridModel;
    }

    public void snapToGrid(GridModel gridModel) {
        if (gridModel.isSnapToGrid()) {
            this.updateListeners = false;
            for (ControlPoint point : this) {
                point.copy(gridModel.snapPointToGrid(point));
            }
            this.updateListeners = true;
            this.fireCurveChanged(this.FULL);
        }
    }

    public void copy(CurveModel model) {
        this.iterations = model.iterations;
        this.grade = model.grade;
        this.controlPointList = model.controlPointList;
        this.curveApproximator = model.curveApproximator;
        this.curvePoints = model.curvePoints;
        this.curveMode = model.curveMode;
        this.curveColor = model.curveColor;
        this.label = model.label;
        this.fireChanged(this.FULL);
    }

    public boolean equals(Object o) {
        CurveModel model = (CurveModel)o;
        return this.iterations == model.iterations && this.grade == model.grade && this.controlPointList == model.controlPointList && this.curveApproximator == model.curveApproximator && this.curvePoints == model.curvePoints && this.curveMode == model.curveMode;
    }

    public void writeToFile(String filename) throws Exception {
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        file.setLength(0L);
        file.writeBoolean(this.curveMode);
        file.writeInt(this.iterations);
        file.writeInt(this.grade);
        file.writeInt(this.getNrOfPoints());
        for (ControlPoint point : this) {
            file.writeDouble(point.getHomX());
            file.writeDouble(point.getHomY());
            file.writeDouble(point.getFactor());
        }
        file.close();
    }

    public void readFromFile(String filename) throws Exception {
        this.updateListeners = false;
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        this.clearCurve();
        this.setCurveMode(file.readBoolean());
        this.iterations = file.readInt();
        this.grade = file.readInt();
        this.setIterations(this.iterations);
        this.setGrade(this.grade);
        int length = file.readInt();
        for (int i = 0; i < length; ++i) {
            double homX = file.readDouble();
            double homY = file.readDouble();
            double factor = file.readDouble();
            ControlPoint p = new ControlPoint(homX, homY);
            p.setFactor(factor);
            this.addControlPoint(p);
        }
        file.close();
        this.updateListeners = true;
        this.fireCurveChanged(this.FULL);
    }
}

