/*
 * Decompiled with CFR 0.152.
 */
package curve;

public class CurvePoint {
    protected double x;
    protected double y;
    protected double z;

    public CurvePoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CurvePoint(double x, double y) {
        this(x, y, 1.0);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public double getHomX() {
        return this.x / this.z;
    }

    public double getHomY() {
        return this.y / this.z;
    }

    public void setHomX(double homX) {
        this.x = homX * this.z;
    }

    public void setHomY(double homY) {
        this.y = homY * this.z;
    }

    public static CurvePoint getCenterPoint(CurvePoint point1, CurvePoint point2) {
        return new CurvePoint((point1.x + point2.x) / 2.0, (point1.y + point2.y) / 2.0, (point1.z + point2.z) / 2.0);
    }
}

