/*
 * Decompiled with CFR 0.152.
 */
package curve;

import curve.CircularList;
import curve.ControlPoint;
import curve.CurveApproximator;
import curve.CurvePoint;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaneRiesenfeld
implements CurveApproximator {
    @Override
    public CircularList approxCurve(int grade, int iterations, boolean closed, List<ControlPoint> controlPointList, CircularList recycle) {
        if (controlPointList.size() < grade + 1) {
            return new CircularList(controlPointList);
        }
        int nrOfCurvePoints = closed ? (1 << iterations) * controlPointList.size() : (1 << iterations) * (controlPointList.size() - grade) + 2 * grade;
        CircularList curveList = recycle != null && recycle.getMaxSize() == nrOfCurvePoints ? recycle : new CircularList(nrOfCurvePoints);
        return this.runLaneRiesenfeld(grade, iterations, closed, controlPointList, curveList);
    }

    private CircularList runLaneRiesenfeld(int grade, int iterations, boolean closed, List<ControlPoint> controlPointList, CircularList list) {
        list.setSize(controlPointList.size());
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, controlPointList.get(i));
        }
        for (int iteration = 0; iteration < iterations; ++iteration) {
            int i;
            int gradeIteration;
            list.doubleList();
            if (closed) {
                for (gradeIteration = 0; gradeIteration < grade; ++gradeIteration) {
                    CurvePoint firstPoint = list.get(0);
                    for (i = 0; i < list.size() - 1; ++i) {
                        list.set(i, CurvePoint.getCenterPoint(list.get(i), list.get(i + 1)));
                    }
                    int lastIndex = list.size() - 1;
                    list.set(lastIndex, CurvePoint.getCenterPoint(list.get(lastIndex), firstPoint));
                }
                continue;
            }
            for (gradeIteration = 0; gradeIteration < grade; ++gradeIteration) {
                for (i = 0; i < list.size() - 1; ++i) {
                    list.set(i, CurvePoint.getCenterPoint(list.get(i), list.get(i + 1)));
                }
                list.setSize(list.size() - 1);
            }
        }
        return list;
    }
}

