/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPointSlider
extends JSlider
implements ChangeListener,
MouseListener {
    protected ControlPoint point;
    protected int value;
    private static final int MIN = -90000;
    private static final int MAX = 100000;
    private static final int DEFAULT = 10000;
    private static final double STEP = 10000.0;
    private static final int NEG_THRESHOLD = -50000;

    public ControlPointSlider(ControlPoint point) {
        super(1, -90000, 100000, 10000);
        this.setControlPoint(point);
        this.addChangeListener(this);
        this.addMouseListener(this);
    }

    public void setControlPoint(ControlPoint point) {
        if (point == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.point = point;
            double factor = point.getFactor();
            this.setValue(this.convertFactorToSlider(factor));
            this.value = this.getValue();
        }
    }

    public ControlPoint getControlPoint() {
        return this.point;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.value != this.getValue()) {
            this.value = this.getValue();
            this.point.setFactor(this.convertSliderToFactor(this.value));
        }
    }

    private double convertSliderToFactor(int sliderVal) {
        int sign;
        int val;
        if (sliderVal < -50000) {
            val = Math.abs(-90000) - Math.abs(-50000) - (Math.abs(-90000) + sliderVal);
            val = -50000 + val;
            sign = -1;
        } else {
            val = sliderVal;
            sign = 1;
        }
        return (double)sign * Math.exp((double)val / 10000.0);
    }

    private int convertFactorToSlider(double factor) {
        int val;
        if (factor > 0.0) {
            val = (int)(Math.log(factor) * 10000.0);
        } else {
            val = (int)(Math.log(factor * -1.0) * 10000.0);
            val -= -50000;
            val = Math.abs(-90000) - Math.abs(-50000) - val - Math.abs(-90000);
        }
        return val;
    }

    public void resetSlider(MouseEvent e) {
        this.setValueIsAdjusting(false);
        for (MouseListener l : this.getMouseListeners()) {
            if (l == this) continue;
            l.mouseClicked(e);
            l.mouseReleased(e);
        }
        this.setValue(0);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            this.resetSlider(e);
        }
    }
}

