/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveModel;
import gui.Disposable;
import gui.HighLightingSlider;
import gui.PointSelectionListener;
import gui.PointSelectionModel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ControlPointSliderPanel
extends JScrollPane
implements Disposable,
PointSelectionListener {
    private PointSelectionModel selectionModel;
    private JPanel panel = new JPanel(null);
    private CurveModel selectedCurveModel;

    public ControlPointSliderPanel(CurveModel selectedCurveModel) {
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(21);
        this.setViewportView(this.panel);
        this.setPreferredSize(new Dimension(370, 250));
        this.selectionModel = selectedCurveModel.getPointSelectionModel();
        this.selectionModel.addPointSelectionListener(this);
        this.selectedCurveModel = selectedCurveModel;
        this.installSliders();
    }

    private void installSliders() {
        if (this.selectedCurveModel.getNrOfPoints() > 0) {
            this.panel.setLayout(new GridLayout(0, this.selectedCurveModel.getNrOfPoints()));
            for (ControlPoint point : this.selectedCurveModel) {
                this.panel.add(new HighLightingSlider(this.selectionModel, point));
            }
        }
    }

    public void updateSliders() {
        this.removeAllSliders();
        this.installSliders();
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void dispose() {
        this.removeAllSliders();
    }

    private void removeAllSliders() {
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            ((HighLightingSlider)this.panel.getComponent(i)).dispose();
        }
        this.panel.removeAll();
    }

    public void valueChanged(PointSelectionModel selectionModel) {
        ControlPoint point = selectionModel.getSelectedPoint();
        if (point != null) {
            int sliderWidth = this.panel.getWidth() / this.selectedCurveModel.getNrOfPoints();
            int sliderPosition = sliderWidth * point.getLabel();
            JViewport view = this.getViewport();
            Rectangle viewRect = view.getViewRect();
            if (sliderPosition < viewRect.x || sliderWidth + sliderPosition > viewRect.x + viewRect.width) {
                view.setViewPosition(new Point(sliderPosition - viewRect.width / 2, viewRect.y));
            }
        }
    }
}

