/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveEvent;
import curve.CurveListener;
import curve.CurveModel;
import curve.CurvePoint;
import gui.CoordinateConvertor;
import gui.CoordinateListener;
import gui.Disposable;
import gui.ZoomableCoordinateConvertor;
import java.awt.Point;
import javax.swing.JPanel;

public class CurveFittingCoordinateConvertor
implements CoordinateConvertor,
CurveListener,
Disposable {
    private ZoomableCoordinateConvertor zoom = new ZoomableCoordinateConvertor();
    private CurveModel curveModel;

    public CurveFittingCoordinateConvertor(CurveModel curveModel) {
        this.curveModel = curveModel;
        curveModel.addCurveListener(this);
        this.zoom.setOptimalZoom(curveModel);
    }

    public void addCoordinateListener(CoordinateListener listener) {
        this.zoom.addCoordinateListener(listener);
    }

    public void removeCoordinateListener(CoordinateListener listener) {
        this.zoom.removeCoordinateListener(listener);
    }

    public double convertPanelDistance(JPanel panel, double distance) {
        return this.zoom.convertPanelDistance(panel, distance);
    }

    public double convertPointDistance(JPanel panel, double distance) {
        return this.zoom.convertPointDistance(panel, distance);
    }

    public ControlPoint getControlPoint(JPanel panel, Point point) {
        return this.zoom.getControlPoint(panel, point);
    }

    public Point getPanelPoint(JPanel panel, CurvePoint point) {
        return this.zoom.getPanelPoint(panel, point);
    }

    public void curveChanged(CurveEvent e) {
        this.zoom.setOptimalZoom(this.curveModel);
    }

    public void dispose() {
        this.curveModel.removeCurveListener(this);
        this.curveModel = null;
        this.zoom = null;
    }
}

