/*
 * Decompiled with CFR 0.152.
 */
package gui;

import actions.ClearPointsAction;
import actions.ToggleDisplayWindowAction;
import actions.ToggleGridAction;
import actions.ToolSelectAction;
import config.OptionModel;
import curve.CurveList;
import curve.CurveModel;
import gui.CurveClosedToggleButton;
import gui.CurveViewPanel;
import gui.EnablePolygonCheckBox;
import gui.GradeSpinner;
import gui.GridModel;
import gui.GridSnapCheckBox;
import gui.IterationSpinner;
import gui.PanTool;
import gui.PointEditTool;
import gui.RotateTool;
import gui.SliderWindow;
import gui.ZoomTool;
import gui.ZoomableCoordinateConvertor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class CurveToolBar
extends JToolBar
implements MouseListener {
    private CurveList curveList;
    private CurveModel curveModel;
    private ZoomableCoordinateConvertor zoom;
    private OptionModel optionModel;
    private GridModel gridModel;
    private CurveViewPanel curvePanel;
    private SliderWindow sliderWindow;

    public CurveToolBar(ZoomableCoordinateConvertor zoom, CurveList curveList, CurveModel curveModel, OptionModel optionModel, GridModel gridModel, CurveViewPanel curvePanel, SliderWindow sliderWindow) {
        this.zoom = zoom;
        this.curveList = curveList;
        this.curveModel = curveModel;
        this.optionModel = optionModel;
        this.gridModel = gridModel;
        this.curvePanel = curvePanel;
        this.sliderWindow = sliderWindow;
        this.setFloatable(false);
        this.addMainFunctions();
    }

    public void addMainFunctions() {
        ButtonGroup group = new ButtonGroup();
        JToggleButton editButton = new JToggleButton(new ToolSelectAction("", new ImageIcon(CurveToolBar.class.getResource("images/wizard.png")), new PointEditTool(this.curvePanel)));
        editButton.setBorderPainted(false);
        editButton.setOpaque(false);
        editButton.setToolTipText("Bewerk de punten");
        group.add(editButton);
        editButton.setSelected(true);
        this.add(editButton);
        JToggleButton zoomButton = new JToggleButton(new ToolSelectAction("", new ImageIcon(CurveToolBar.class.getResource("images/viewmagfit.png")), new ZoomTool(this.curvePanel, this.zoom)));
        zoomButton.setBorderPainted(false);
        zoomButton.setOpaque(false);
        zoomButton.setToolTipText("Zoom Tool");
        group.add(zoomButton);
        this.add(zoomButton);
        JToggleButton panButton = new JToggleButton(new ToolSelectAction("", new ImageIcon(CurveToolBar.class.getResource("images/move.png")), new PanTool(this.curvePanel, this.zoom)));
        panButton.setBorderPainted(false);
        panButton.setOpaque(false);
        panButton.setToolTipText("Verschuif de afbeelding door te slepen");
        this.add(panButton);
        group.add(panButton);
        JToggleButton rotateButton = new JToggleButton(new ToolSelectAction("", new ImageIcon(CurveToolBar.class.getResource("images/rotate.png")), new RotateTool(this.curvePanel, this.curveModel)));
        rotateButton.setBorderPainted(false);
        rotateButton.setOpaque(false);
        rotateButton.setToolTipText("Rotatie Tool");
        group.add(rotateButton);
        this.add(rotateButton);
        this.add(new JSeparator(1));
        JButton clearPoints = new JButton(new ClearPointsAction(this.curveModel));
        clearPoints.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/view_remove.png")));
        clearPoints.setText("");
        clearPoints.setOpaque(false);
        clearPoints.setBorderPainted(false);
        clearPoints.setToolTipText("Wis alle punten");
        this.add(clearPoints);
        JButton toggleGrid = new JButton(new ToggleGridAction(this.gridModel));
        toggleGrid.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/grid.png")));
        toggleGrid.setText("");
        toggleGrid.setBorderPainted(false);
        toggleGrid.setOpaque(false);
        toggleGrid.setToolTipText("Grid aan- of uitzetten");
        this.add(toggleGrid);
        GridSnapCheckBox gs = new GridSnapCheckBox(this.gridModel);
        gs.setText("snap?");
        gs.setHorizontalTextPosition(0);
        gs.setVerticalTextPosition(3);
        gs.setToolTipText("snap-to-grid?");
        gs.setBorderPainted(false);
        gs.setOpaque(false);
        gs.setSelectedIcon(new ImageIcon(CurveToolBar.class.getResource("images/ok.png")));
        gs.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/no.png")));
        this.add(gs);
        CurveClosedToggleButton curveClose = new CurveClosedToggleButton(this.curveModel);
        curveClose.setText("");
        curveClose.setSelectedIcon(new ImageIcon(CurveToolBar.class.getResource("images/encrypted.png")));
        curveClose.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/unlock.png")));
        curveClose.setBorderPainted(false);
        curveClose.setOpaque(false);
        curveClose.setToolTipText("Sluit de curve");
        this.add(curveClose);
        EnablePolygonCheckBox enpol = new EnablePolygonCheckBox(this.optionModel);
        enpol.setText("");
        enpol.setBorderPainted(false);
        enpol.setOpaque(false);
        enpol.setSelectedIcon(new ImageIcon(CurveToolBar.class.getResource("images/hulplijnok.png")));
        enpol.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/hulplijnfalse.png")));
        enpol.setToolTipText("Teken controleveelhoek?");
        this.add(enpol);
        JButton dispSliders = new JButton(new ToggleDisplayWindowAction(this.sliderWindow));
        dispSliders.setText("");
        dispSliders.setOpaque(false);
        dispSliders.setIcon(new ImageIcon(CurveToolBar.class.getResource("images/today.png")));
        dispSliders.setBorderPainted(false);
        dispSliders.setToolTipText("Open het slidervenster");
        this.add(dispSliders);
        this.add(new JSeparator(1));
        this.add(new JLabel("iteratie:"));
        JSpinner spinner = new IterationSpinner(this.curveModel);
        spinner.addMouseListener(this);
        this.add(spinner);
        this.add(new JLabel(" graad:"));
        spinner = new GradeSpinner(this.curveModel);
        spinner.addMouseListener(this);
        this.add(spinner);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.curvePanel.requestFocusInWindow();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

