/*
 * Decompiled with CFR 0.152.
 */
package gui;

import config.OptionListener;
import config.OptionModel;
import curve.CircularList;
import curve.ControlPoint;
import curve.CurveEvent;
import curve.CurveList;
import curve.CurveListener;
import curve.CurveModel;
import curve.CurvePoint;
import curve.CurveSelectionListener;
import gui.CoordinateConvertor;
import gui.CoordinateListener;
import gui.CurvePanelTool;
import gui.Disposable;
import gui.GridListener;
import gui.GridModel;
import gui.PointEditTool;
import gui.PointSelectionListener;
import gui.PointSelectionModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class CurveViewPanel
extends JPanel
implements CurveListener,
OptionListener,
GridListener,
CoordinateListener,
PointSelectionListener,
CurveSelectionListener,
Disposable {
    protected CurveModel selectedCurveModel;
    protected OptionModel optionModel;
    protected CoordinateConvertor convert;
    protected CurvePanelTool currentTool;
    protected GridModel gridModel;
    protected CurveList curveList;
    protected Color panelColor;

    public CurveViewPanel(OptionModel optionModel, CoordinateConvertor convert, CurveList curveList) {
        super(null);
        this.curveList = curveList;
        this.selectedCurveModel = curveList.getSelectedCurve();
        this.setOptionModel(optionModel);
        this.setGridModel(curveList.getGridModel());
        this.setCoordinateConvertor(convert);
        this.setCurveModel(this.selectedCurveModel);
        this.setTool(new PointEditTool(this));
        this.panelColor = optionModel.getPanelColor();
        this.setPanelColor();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawGrid(g2);
        for (CurveModel drawCurveModel : this.curveList) {
            this.drawCurve(g2, drawCurveModel, this.curveList.isSelected(drawCurveModel));
        }
        this.currentTool.paintComponent(g2);
    }

    private void drawCurve(Graphics2D g2, CurveModel drawingCurveModel, boolean selected) {
        g2.setStroke(this.optionModel.getCurveStroke(drawingCurveModel));
        if (this.optionModel.isAAEnabled().booleanValue()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (drawingCurveModel != null) {
            CurvePoint endPoint;
            CurvePoint beginPoint;
            CircularList pointlist = drawingCurveModel.approxCurve();
            if (pointlist.size() < 1 || drawingCurveModel.getNrOfPoints() < 1) {
                return;
            }
            CurvePoint firstPoint = beginPoint = pointlist.first();
            if (this.optionModel.getDrawCurvePoints() & selected) {
                g2.setPaint(Color.BLACK);
                Point p = this.convert.getPanelPoint(this, beginPoint);
                g2.draw(new Rectangle2D.Double(p.getX() - 1.0, p.getY() - 1.0, 3.0, 3.0));
            }
            for (int i = 1; i < pointlist.size(); ++i) {
                g2.setPaint(drawingCurveModel.getCurveColor());
                endPoint = pointlist.get(i);
                g2.draw(this.getLine(beginPoint, endPoint));
                beginPoint = endPoint;
                if (!(this.optionModel.getDrawCurvePoints() & selected)) continue;
                g2.setPaint(Color.BLACK);
                Point p = this.convert.getPanelPoint(this, beginPoint);
                g2.draw(new Rectangle2D.Double(p.getX() - 1.0, p.getY() - 1.0, 3.0, 3.0));
            }
            if (drawingCurveModel.getCurveMode()) {
                g2.setPaint(drawingCurveModel.getCurveColor());
                g2.draw(this.getLine(beginPoint, firstPoint));
            }
            if (!selected) {
                return;
            }
            ControlPoint selectedPoint = drawingCurveModel.getPointSelectionModel().getSelectedPoint();
            if (selectedPoint != null) {
                int begin = pointlist.getLeftInfluencedPoint(drawingCurveModel, selectedPoint.getLabel());
                int end = pointlist.getRightInfluencedPoint(drawingCurveModel, selectedPoint.getLabel());
                beginPoint = pointlist.get(begin);
                g2.setPaint(drawingCurveModel.getCurveColor().darker().darker());
                g2.setStroke(new BasicStroke(this.optionModel.getHighLightWidth().floatValue()));
                for (int i = begin; i < end; ++i) {
                    endPoint = pointlist.get(i);
                    g2.draw(this.getLine(beginPoint, endPoint));
                    beginPoint = endPoint;
                }
            }
            if (this.optionModel.isPolygonEnabled().booleanValue() && drawingCurveModel.getNrOfPoints() > drawingCurveModel.getGrade()) {
                ControlPoint firstControlPoint;
                ControlPoint prevControlPoint = firstControlPoint = drawingCurveModel.iterator().next();
                for (ControlPoint point : drawingCurveModel) {
                    g2.setPaint(this.optionModel.getPolygonPaint());
                    g2.setStroke(this.optionModel.getPolygonStroke());
                    g2.draw(this.getLine(prevControlPoint, point));
                    prevControlPoint = point;
                }
                if (drawingCurveModel.getCurveMode()) {
                    g2.setPaint(this.optionModel.getPolygonPaint());
                    g2.setStroke(this.optionModel.getPolygonStroke());
                    g2.draw(this.getLine(firstControlPoint, prevControlPoint));
                }
            }
            int pSize = Math.min(this.getHeight(), this.getWidth()) / 50;
            if (this.optionModel.isDrawPointsEnabled().booleanValue()) {
                for (ControlPoint point : drawingCurveModel) {
                    Point panelPoint = this.convert.getPanelPoint(this, point);
                    this.optionModel.getPointRenderer().drawPoint(g2, panelPoint, pSize, point.isSelected());
                }
            }
        }
    }

    private void drawGrid(Graphics2D g2) {
        Point gridPoint = this.convert.getPanelPoint(this, new CurvePoint(0.0, 0.0));
        double gridDistance = this.convert.convertPointDistance(this, this.gridModel.getGridMargin());
        Point2D.Double llPoint = new Point2D.Double(gridPoint.getX() % gridDistance, gridPoint.getY() % gridDistance);
        if (this.gridModel.isEnabled()) {
            if (gridDistance > 1.0) {
                if (!this.panelColor.equals(this.getBackground())) {
                    this.setBackground(this.panelColor);
                }
                g2.setStroke(this.optionModel.getGridStroke());
                g2.setPaint(this.optionModel.getGridColor());
                int width = this.getWidth();
                int height = this.getHeight();
                for (double x = ((Point2D)llPoint).getX(); x <= (double)width; x += gridDistance) {
                    g2.draw(new Line2D.Double(new Point2D.Double(x, 0.0), new Point2D.Double(x, height)));
                }
                for (double y = ((Point2D)llPoint).getY(); y <= (double)height; y += gridDistance) {
                    g2.draw(new Line2D.Double(new Point2D.Double(0.0, y), new Point2D.Double(width, y)));
                }
            } else {
                this.setBackground(this.optionModel.getGridColor());
            }
        }
    }

    private Line2D getLine(CurvePoint point1, CurvePoint point2) {
        return new Line2D.Double(this.convert.getPanelPoint(this, point1), this.convert.getPanelPoint(this, point2));
    }

    private void setPanelColor() {
        if (!this.panelColor.equals(this.optionModel.getPanelColor())) {
            this.panelColor = this.optionModel.getPanelColor();
            this.setBackground(this.panelColor);
        }
    }

    public void setCoordinateConvertor(CoordinateConvertor newZoom) {
        if (this.convert != null) {
            this.convert.removeCoordinateListener(this);
        }
        this.convert = newZoom;
        if (newZoom != null) {
            this.convert.addCoordinateListener(this);
        }
    }

    public void setCurveList(CurveList newCurveList) {
        if (this.curveList != null) {
            this.curveList.removeCurveSelectionListener(this);
        }
        this.curveList = newCurveList;
        if (newCurveList != null) {
            newCurveList.addCurveSelectionListener(this);
        }
    }

    public void setGridModel(GridModel newGridModel) {
        if (this.gridModel != null) {
            this.gridModel.removeGridListener(this);
        }
        this.gridModel = newGridModel;
        if (newGridModel != null) {
            newGridModel.addGridListener(this);
        }
    }

    public void setOptionModel(OptionModel newOptionModel) {
        if (this.optionModel != null) {
            this.optionModel.removeOptionListener(this);
        }
        this.optionModel = newOptionModel;
        if (newOptionModel != null) {
            newOptionModel.addOptionListener(this);
        }
    }

    public void setTool(CurvePanelTool tool) {
        if (tool == this.currentTool) {
            return;
        }
        if (this.currentTool != null) {
            this.removeMouseListener(this.currentTool);
            this.removeMouseMotionListener(this.currentTool);
        }
        this.currentTool = tool;
        this.addMouseListener(this.currentTool);
        this.addMouseMotionListener(this.currentTool);
        this.setCursor(this.currentTool.getCursor());
        this.repaint();
    }

    public void setCurveModel(CurveModel newModel) {
        if (this.selectedCurveModel != null) {
            this.selectedCurveModel.removeCurveListener(this);
            this.selectedCurveModel.getPointSelectionModel().removePointSelectionListener(this);
        }
        this.selectedCurveModel = newModel;
        if (newModel != null) {
            newModel.addCurveListener(this);
            this.selectedCurveModel.getPointSelectionModel().addPointSelectionListener(this);
        }
    }

    public void curveChanged(CurveEvent e) {
        this.repaint();
    }

    public void valueChanged(PointSelectionModel selectionModel) {
        this.repaint();
    }

    public void gridChanged(GridModel gridModel) {
        this.repaint();
    }

    public void optionChanged(OptionModel optionModel) {
        this.setPanelColor();
        this.repaint();
    }

    public void coordinatesChanged() {
        this.repaint();
    }

    public void selectionChanged(CurveList list) {
        this.repaint();
    }

    public GridModel getGridModel() {
        return this.gridModel;
    }

    public CoordinateConvertor getCoordinateConvertor() {
        return this.convert;
    }

    public CurveModel getCurveModel() {
        return this.selectedCurveModel;
    }

    public CurvePanelTool getTool() {
        return this.currentTool;
    }

    public CurveList getCurveList() {
        return this.curveList;
    }

    public void dispose() {
        this.setCurveModel(null);
        this.setGridModel(null);
        this.setOptionModel(null);
        this.setCoordinateConvertor(null);
    }
}

