/*
 * Decompiled with CFR 0.152.
 */
package gui;

import actions.DecreaseGradeAction;
import actions.DecreaseGridAction;
import actions.DecreaseIterationAction;
import actions.ExitAction;
import actions.ExportCurveToPNGAction;
import actions.FitCurveAction;
import actions.FitCurvesAction;
import actions.HelpAction;
import actions.IncreaseGradeAction;
import actions.IncreaseGridAction;
import actions.IncreaseIterationAction;
import actions.LoadCurveAction;
import actions.RotateAction;
import actions.SaveCurveAction;
import actions.ToggleCurveClosedAction;
import actions.ToggleDisplayWindowAction;
import actions.ToggleGridAction;
import config.OptionModel;
import curve.CurveList;
import curve.CurveModel;
import curve.LaneRiesenfeld;
import gui.CurveToolBar;
import gui.CurveViewPanel;
import gui.GridModel;
import gui.MultipleCurveMenu;
import gui.OptionMenu;
import gui.SliderWindow;
import gui.ZoomableCoordinateConvertor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class CurveViewWindow
extends JFrame
implements MouseListener {
    private JPanel contentPane = new JPanel(new BorderLayout());
    private CurveModel curveModel = new CurveModel(new LaneRiesenfeld());
    private GridModel gridModel;
    private OptionModel optionModel;
    private CurveViewPanel curvePanel;
    private CurveList curveList = new CurveList(this.curveModel);
    private SliderWindow sliderWindow;

    public CurveViewWindow() {
        super("Lane Riesenfeld (c) 2005 NN,BC,JJ");
        this.optionModel = new OptionModel(this.curveModel);
        this.gridModel = new GridModel();
        this.curveList.setGridModel(this.gridModel);
        ZoomableCoordinateConvertor convertor = new ZoomableCoordinateConvertor();
        this.curvePanel = new CurveViewPanel(this.optionModel, convertor, this.curveList);
        this.sliderWindow = new SliderWindow((Frame)this, this.optionModel, this.curveList);
        JMenuBar menu = new JMenuBar();
        this.curvePanel.addMouseListener(this);
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(800, 600));
        this.contentPane.setPreferredSize(new Dimension(800, 600));
        this.curvePanel.setPreferredSize(new Dimension(800, 600));
        this.contentPane.add((Component)this.curvePanel, "Center");
        this.contentPane.add((Component)new CurveToolBar(convertor, this.curveList, this.curveModel, this.optionModel, this.gridModel, this.curvePanel, this.sliderWindow), "North");
        JMenu fileMenu = new JMenu("Bestand");
        fileMenu.add(new JMenuItem(new SaveCurveAction(this.curvePanel, this.curveModel)));
        fileMenu.add(new JMenuItem(new LoadCurveAction(this.curvePanel, this.curveModel)));
        fileMenu.add(new ExportCurveToPNGAction(this.curvePanel));
        fileMenu.add(new ExitAction());
        menu.add(fileMenu);
        menu.add(new OptionMenu(this.optionModel));
        JMenu viewMenu = new JMenu("Beeld");
        viewMenu.add(new JMenuItem(new FitCurveAction(convertor, this.curveModel)));
        viewMenu.add(new JMenuItem(new FitCurvesAction(convertor, this.curveList)));
        menu.add(viewMenu);
        menu.add(new MultipleCurveMenu(this.optionModel, this.curvePanel.getCurveList()));
        menu.add(Box.createHorizontalGlue());
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(new JMenuItem(new HelpAction(this)));
        menu.add(helpMenu);
        this.setContentPane(this.contentPane);
        this.initActionMap();
        this.initInputMap();
        this.setJMenuBar(menu);
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    public void initActionMap() {
        ActionMap am = new ActionMap();
        am.setParent(this.contentPane.getActionMap());
        am.put("incgrade", new IncreaseGradeAction(this.curveModel));
        am.put("decgrade", new DecreaseGradeAction(this.curveModel));
        am.put("inciter", new IncreaseIterationAction(this.curveModel));
        am.put("deciter", new DecreaseIterationAction(this.curveModel));
        am.put("openclose", new ToggleCurveClosedAction(this.curveModel));
        am.put("sliders", new ToggleDisplayWindowAction(this.sliderWindow));
        am.put("grid", new ToggleGridAction(this.gridModel));
        am.put("incgrid", new IncreaseGridAction(this.gridModel));
        am.put("decgrid", new DecreaseGridAction(this.gridModel));
        am.put("rotate", new RotateAction(this.curveModel, this.curvePanel));
        this.contentPane.setActionMap(am);
    }

    public void initInputMap() {
        InputMap im = new InputMap();
        im.setParent(this.contentPane.getInputMap());
        im.put(KeyStroke.getKeyStroke("UP"), "incgrade");
        im.put(KeyStroke.getKeyStroke("DOWN"), "decgrade");
        im.put(KeyStroke.getKeyStroke("RIGHT"), "inciter");
        im.put(KeyStroke.getKeyStroke("LEFT"), "deciter");
        im.put(KeyStroke.getKeyStroke("O"), "openclose");
        im.put(KeyStroke.getKeyStroke("E"), "sliders");
        im.put(KeyStroke.getKeyStroke("G"), "grid");
        im.put(KeyStroke.getKeyStroke("SPACE"), "incgrid");
        im.put(KeyStroke.getKeyStroke("BACK_SPACE"), "decgrid");
        im.put(KeyStroke.getKeyStroke("R"), "rotate");
        this.contentPane.setInputMap(0, im);
        this.contentPane.requestFocusInWindow();
    }

    public void mouseClicked(MouseEvent e) {
        this.contentPane.requestFocusInWindow();
    }

    public void mouseEntered(MouseEvent e) {
        this.contentPane.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

