/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PointRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class DefaultPointRenderer
implements PointRenderer {
    private Color innerColor;
    private double innerCircleFactor;
    private double innerCircleFactor2;

    public DefaultPointRenderer(double innerCircleFactor, double innerCircleFactor2, Color innerColor) {
        this.innerCircleFactor = innerCircleFactor;
        this.innerCircleFactor2 = innerCircleFactor2;
        this.innerColor = innerColor;
    }

    public DefaultPointRenderer() {
        this(0.7, 0.5, Color.BLACK);
    }

    public void drawPoint(Graphics2D g2, Point point, int size, boolean selected) {
        this.drawPoint(g2, (int)point.getX(), (int)point.getY(), size, 1.5, selected, Color.BLUE, Color.RED);
    }

    public void drawPoint(Graphics2D g2, int centerX, int centerY, int size, double selectedSizeFactor, boolean selected, Paint color, Paint selectedColor) {
        if (size < 7) {
            if (selected) {
                size = (int)((double)size * selectedSizeFactor);
            }
            g2.setPaint(selected ? selectedColor : color);
            g2.fill(new Ellipse2D.Double(centerX - size / 2, centerY - size / 2, size, size));
        } else {
            size = 12;
            if (selected) {
                size = (int)((double)size * selectedSizeFactor);
            }
            int outerRadius = size / 2;
            int innerRadius = (int)((double)outerRadius * this.innerCircleFactor);
            g2.setPaint(selected ? selectedColor : color);
            Area area = new Area(new Ellipse2D.Double(centerX - outerRadius, centerY - outerRadius, size, size));
            Area area2 = new Area(new Ellipse2D.Double(centerX - innerRadius, centerY - innerRadius, innerRadius * 2, innerRadius * 2));
            area.subtract(area2);
            g2.fill(area);
            g2.setPaint(this.innerColor);
            int radius = (int)((double)outerRadius * this.innerCircleFactor2);
            g2.fill(new Ellipse2D.Double(centerX - radius, centerY - radius, radius * 2, radius * 2));
        }
    }
}

