/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import gui.GridListener;
import java.util.HashSet;
import java.util.Set;

public class GridModel {
    private Set<GridListener> listenerSet = new HashSet<GridListener>();
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;
    public static final boolean DEFAULT_GRID_MODE = false;
    public static final double DEFAULT_GRID_MARGIN = 0.02;
    public static final double GRID_MINIMUM = 0.01;
    public static final boolean SNAP_TO_GRID = true;
    public static final boolean NO_SNAP = false;
    public static final double STEP = 0.01;
    private double gridMargin;
    private boolean enabled;
    private boolean snapToGrid;

    public void addGridListener(GridListener l) {
        this.listenerSet.add(l);
    }

    public void removeGridListener(GridListener l) {
        this.listenerSet.remove(l);
    }

    protected void fireGridChanged() {
        for (GridListener listener : this.listenerSet) {
            listener.gridChanged(this);
        }
    }

    public GridModel(double gridMargin) {
        this.gridMargin = gridMargin;
        this.enabled = false;
        this.snapToGrid = false;
    }

    public GridModel() {
        this(0.02);
    }

    public double getGridMargin() {
        return this.gridMargin;
    }

    public void setGridMargin(double gridMargin) {
        if (this.enabled && gridMargin >= 0.01) {
            this.gridMargin = gridMargin;
        }
        this.fireGridChanged();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMode(boolean enabled) {
        this.enabled = enabled;
        this.fireGridChanged();
    }

    public void toggleEnabled() {
        this.setMode(!this.enabled);
    }

    public void toggleEnabled(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
        this.setMode(!this.enabled);
    }

    public void setSnapToGrid(boolean snapToGrid) {
        if (this.enabled) {
            this.snapToGrid = snapToGrid;
            this.fireGridChanged();
        }
    }

    public void toggleSnapToGrid() {
        this.setSnapToGrid(!this.snapToGrid);
    }

    public boolean isSnapToGrid() {
        return this.enabled && this.snapToGrid;
    }

    public ControlPoint snapPointToGrid(ControlPoint point) {
        double x = (double)((int)(point.getHomX() / this.gridMargin)) * this.gridMargin;
        double y = (double)((int)(point.getHomY() / this.gridMargin)) * this.gridMargin;
        int signX = point.getHomX() > 0.0 ? 1 : -1;
        int signY = point.getHomY() > 0.0 ? 1 : -1;
        ControlPoint pointUL = new ControlPoint(x, y);
        ControlPoint pointUR = new ControlPoint(x + (double)signX * this.gridMargin, y);
        ControlPoint pointDL = new ControlPoint(x, y + (double)signY * this.gridMargin);
        ControlPoint pointDR = new ControlPoint(x + (double)signX * this.gridMargin, y + (double)signY * this.gridMargin);
        double minDistance = this.gridMargin * 2.0;
        ControlPoint closestPoint = point;
        double distance = point.distance(pointUL);
        if (distance < minDistance) {
            minDistance = distance;
            closestPoint = pointUL;
        }
        if ((distance = point.distance(pointUR)) < minDistance) {
            minDistance = distance;
            closestPoint = pointUR;
        }
        if ((distance = point.distance(pointDL)) < minDistance) {
            minDistance = distance;
            closestPoint = pointDL;
        }
        if ((distance = point.distance(pointDR)) < minDistance) {
            minDistance = distance;
            closestPoint = pointDR;
        }
        return closestPoint;
    }
}

