/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import gui.ControlPointSlider;
import gui.Disposable;
import gui.PointSelectionListener;
import gui.PointSelectionModel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HighLightingSlider
extends JPanel
implements FocusListener,
PointSelectionListener,
MouseListener,
Disposable {
    protected PointSelectionModel selectionModel;
    protected ControlPointSlider slider;

    public HighLightingSlider(PointSelectionModel selectionModel, ControlPoint point) {
        super(new FlowLayout());
        this.slider = new ControlPointSlider(point);
        this.add(this.slider);
        this.slider.addFocusListener(this);
        this.addMouseListener(this);
        this.selectionModel = selectionModel;
        selectionModel.addPointSelectionListener(this);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void focusGained(FocusEvent e) {
        this.setSliderSelected(true);
        this.selectionModel.setSelection(this.slider.getControlPoint());
    }

    public void focusLost(FocusEvent e) {
        this.setSliderSelected(false);
        this.selectionModel.undoSelection();
    }

    public void valueChanged(PointSelectionModel selectionModel) {
        this.setSliderSelected(selectionModel.getSelectedPoint() == this.slider.getControlPoint());
    }

    private void setSliderSelected(boolean selected) {
        if (selected) {
            this.setBorder(BorderFactory.createEtchedBorder(Color.RED.darker().darker(), Color.GRAY));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.slider.requestFocusInWindow();
        if (e.getButton() != 1) {
            this.slider.resetSlider(e);
        }
    }

    public void dispose() {
        this.slider.removeFocusListener(this);
        this.removeMouseListener(this);
        this.selectionModel.removePointSelectionListener(this);
        this.slider = null;
        this.selectionModel = null;
    }
}

