/*
 * Decompiled with CFR 0.152.
 */
package gui;

import actions.AddCurveAction;
import actions.RemoveCurveAction;
import actions.SelectCurveAction;
import config.OptionListener;
import config.OptionModel;
import curve.CurveList;
import curve.CurveModel;
import curve.CurveSelectionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class MultipleCurveMenu
extends JMenu
implements CurveSelectionListener,
OptionListener {
    private CurveList curveList;
    private JMenu curveSelectMenu;

    public MultipleCurveMenu(OptionModel optionModel, CurveList curveList) {
        super("Curves ...");
        this.curveList = curveList;
        this.curveSelectMenu = new JMenu("Selecteer curve");
        this.installMenuItems();
        curveList.addCurveSelectionListener(this);
        optionModel.addOptionListener(this);
        this.add(new JMenuItem(new AddCurveAction(curveList)));
        this.add(new JMenuItem(new RemoveCurveAction(curveList)));
        this.add(this.curveSelectMenu);
    }

    public void selectionChanged(CurveList list) {
        this.installMenuItems();
    }

    public void installMenuItems() {
        this.curveSelectMenu.removeAll();
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.curveList.nrOfCurves(); ++i) {
            CurveModel curve = this.curveList.getCurve(i);
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(new SelectCurveAction(this.curveList, i));
            button.setForeground(curve.getCurveColor());
            group.add(button);
            button.setSelected(this.curveList.isSelected(curve));
            this.curveSelectMenu.add(button);
        }
        this.curveSelectMenu.revalidate();
    }

    public void optionChanged(OptionModel optionModel) {
        this.installMenuItems();
    }
}

