/*
 * Decompiled with CFR 0.152.
 */
package gui;

import actions.AbstractOptionAction;
import actions.BooleanOptionAction;
import actions.ColorOptionAction;
import actions.LineWidthOptionAction;
import config.OptionAnnotation;
import config.OptionListener;
import config.OptionModel;
import java.lang.reflect.Method;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class OptionMenu
extends JMenu {
    private OptionModel model;

    public OptionMenu(OptionModel model) {
        super("Opties");
        this.model = model;
        this.generateMenu();
    }

    /*
     * WARNING - void declaration
     */
    private void generateMenu() {
        void var4_6;
        TreeSet<JMenuItem> set = new TreeSet<JMenuItem>();
        Method[] arr$ = this.model.getClass().getMethods();
        int len$ = arr$.length;
        boolean bl = false;
        while (var4_6 < len$) {
            Method method = arr$[var4_6];
            if (method.isAnnotationPresent(OptionAnnotation.class)) {
                OptionAnnotation annotation = method.getAnnotation(OptionAnnotation.class);
                if (annotation.type().equals((Object)OptionModel.OptionType.BOOLEAN)) {
                    set.add(new CheckOptionMenu(new BooleanOptionAction(annotation, this.model)));
                } else if (annotation.type().equals((Object)OptionModel.OptionType.COLOR)) {
                    set.add(new ColorOptionMenu(new ColorOptionAction(annotation, this.model)));
                } else if (annotation.type().equals((Object)OptionModel.OptionType.LINEWIDTH)) {
                    set.add(new LineWidthOptionMenu(new LineWidthOptionAction(annotation, this.model)));
                }
            }
            ++var4_6;
        }
        String prevGroup = null;
        for (GroupedMenu groupedMenu : set) {
            if (prevGroup != null) {
                if (!prevGroup.equals(groupedMenu.getAnnotation().group())) {
                    this.addSeparator();
                    prevGroup = groupedMenu.getAnnotation().group();
                }
            } else {
                prevGroup = groupedMenu.getAnnotation().group();
            }
            this.add((JMenuItem)((Object)groupedMenu));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineWidthOptionMenu
    extends JMenu
    implements OptionListener,
    GroupedMenu,
    Comparable<GroupedMenu> {
        private AbstractOptionAction action;
        private JRadioButtonMenuItem small;
        private JRadioButtonMenuItem normal;
        private JRadioButtonMenuItem big;

        public LineWidthOptionMenu(AbstractOptionAction action) {
            super(action);
            this.action = action;
            ButtonGroup group = new ButtonGroup();
            this.small = new JRadioButtonMenuItem("Dun");
            this.normal = new JRadioButtonMenuItem("Normaal");
            this.big = new JRadioButtonMenuItem("Dik");
            this.small.setActionCommand("SMALL");
            this.normal.setActionCommand("NORMAL");
            this.big.setActionCommand("BIG");
            group.add(this.small);
            group.add(this.normal);
            group.add(this.big);
            this.add(this.small);
            this.add(this.normal);
            this.add(this.big);
            this.optionChanged(action.getModel());
            action.getModel().addOptionListener(this);
            this.small.addActionListener(action);
            this.normal.addActionListener(action);
            this.big.addActionListener(action);
        }

        @Override
        public void optionChanged(OptionModel optionModel) {
            if (this.action.getValue() == OptionModel.LINE_SMALL) {
                this.small.setSelected(true);
            } else if (this.action.getValue() == OptionModel.LINE_NORMAL) {
                this.normal.setSelected(true);
            } else {
                this.big.setSelected(true);
            }
        }

        @Override
        public OptionAnnotation getAnnotation() {
            return this.action.getAnnotation();
        }

        @Override
        public int compareTo(GroupedMenu o) {
            if (this.action.getAnnotation().group().equals(o.getAnnotation().group())) {
                return this.action.getAnnotation().name().compareTo(o.getAnnotation().name());
            }
            return this.action.getAnnotation().group().compareTo(o.getAnnotation().group());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColorOptionMenu
    extends JMenuItem
    implements OptionListener,
    GroupedMenu,
    Comparable<GroupedMenu> {
        private AbstractOptionAction action;

        public ColorOptionMenu(AbstractOptionAction action) {
            super(action);
            this.action = action;
            this.optionChanged(action.getModel());
            action.getModel().addOptionListener(this);
        }

        @Override
        public void optionChanged(OptionModel optionModel) {
        }

        @Override
        public OptionAnnotation getAnnotation() {
            return this.action.getAnnotation();
        }

        @Override
        public int compareTo(GroupedMenu o) {
            if (this.action.getAnnotation().group().equals(o.getAnnotation().group())) {
                return this.action.getAnnotation().name().compareTo(o.getAnnotation().name());
            }
            return this.action.getAnnotation().group().compareTo(o.getAnnotation().group());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckOptionMenu
    extends JCheckBoxMenuItem
    implements OptionListener,
    GroupedMenu,
    Comparable<GroupedMenu> {
        private AbstractOptionAction action;

        public CheckOptionMenu(AbstractOptionAction action) {
            super(action);
            this.action = action;
            this.optionChanged(action.getModel());
            action.getModel().addOptionListener(this);
        }

        @Override
        public void optionChanged(OptionModel optionModel) {
            this.setSelected((Boolean)this.action.getValue());
        }

        @Override
        public OptionAnnotation getAnnotation() {
            return this.action.getAnnotation();
        }

        @Override
        public int compareTo(GroupedMenu o) {
            if (this.action.getAnnotation().group().equals(o.getAnnotation().group())) {
                return this.action.getAnnotation().name().compareTo(o.getAnnotation().name());
            }
            return this.action.getAnnotation().group().compareTo(o.getAnnotation().group());
        }
    }

    private static interface GroupedMenu {
        public OptionAnnotation getAnnotation();
    }
}

