/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CurvePanelToolAdapter;
import gui.CurveViewPanel;
import gui.ZoomableCoordinateConvertor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PanTool
extends CurvePanelToolAdapter {
    private Point grabbedPoint = null;
    private double originalX;
    private double originalY;
    private ZoomableCoordinateConvertor zoomConvert;

    public PanTool(CurveViewPanel p, ZoomableCoordinateConvertor zoomConvert) {
        super(p);
        this.zoomConvert = zoomConvert;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.grabbedPoint = e.getPoint();
            this.originalX = this.zoomConvert.getCenterX();
            this.originalY = this.zoomConvert.getCenterY();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.grabbedPoint == null) {
            return;
        }
        this.zoomConvert.setCenterPoint(this.originalX + this.zoomConvert.convertPanelDistance(this.panel, this.grabbedPoint.getX() - (double)e.getX()), this.originalY + this.zoomConvert.convertPanelDistance(this.panel, this.grabbedPoint.getY() - (double)e.getY()));
    }

    public void mouseReleased(MouseEvent e) {
        this.grabbedPoint = null;
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }
}

