/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveModel;
import gui.CoordinateConvertor;
import gui.CurvePanelToolAdapter;
import gui.CurveViewPanel;
import gui.PointSelectionModel;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class PointEditTool
extends CurvePanelToolAdapter {
    protected PointSelectionModel selectionModel;
    private ControlPoint grabbedPoint = null;
    private ControlPoint backupPoint = new ControlPoint(0.0, 0.0);
    private CoordinateConvertor convert;
    private CurveModel selectedCurveModel;

    public PointEditTool(CurveViewPanel panel) {
        super(panel);
        this.selectionModel = panel.getCurveModel().getPointSelectionModel();
        this.convert = panel.getCoordinateConvertor();
        this.selectedCurveModel = panel.getCurveModel();
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            ControlPoint newPoint = this.convert.getControlPoint(this.panel, e.getPoint());
            ControlPoint closestPoint = this.selectedCurveModel.locateClosestPoint(newPoint, this.convert.convertPanelDistance(this.panel, 12.0));
            if (closestPoint == null) {
                this.selectedCurveModel.addControlPoint(newPoint);
            } else {
                this.grabbedPoint = closestPoint;
                this.selectionModel.setSelection(this.grabbedPoint);
                this.backupPoint.copy(this.grabbedPoint);
            }
        } else {
            this.panel.getCurveModel().removeLastPoint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.grabbedPoint != null) {
            this.grabbedPoint.copy(this.convert.getControlPoint(this.panel, e.getPoint()));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.grabbedPoint != null) {
            if (e.getX() > this.panel.getWidth() || e.getY() > this.panel.getHeight() || e.getX() < 0 || e.getY() < 0) {
                this.grabbedPoint.copy(this.backupPoint);
            } else if (this.panel.getGridModel().isSnapToGrid()) {
                ControlPoint clickPoint = this.convert.getControlPoint(this.panel, e.getPoint());
                this.grabbedPoint.copy(this.panel.getGridModel().snapPointToGrid(clickPoint));
            }
            this.selectionModel.undoSelection();
            this.grabbedPoint = null;
        }
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(0);
    }
}

