/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveModel;
import gui.CoordinateConvertor;
import gui.CurvePanelToolAdapter;
import gui.CurveViewPanel;
import gui.PointSelectionModel;
import java.awt.event.MouseEvent;

public class PointSelectTool
extends CurvePanelToolAdapter {
    protected PointSelectionModel selectionModel;
    protected CoordinateConvertor convert;
    protected CurveModel curveModel;

    public PointSelectTool(CurveViewPanel panel, CurveModel curveModel) {
        super(panel);
        this.curveModel = curveModel;
        this.selectionModel = curveModel.getPointSelectionModel();
        this.convert = panel.getCoordinateConvertor();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            ControlPoint clickPoint = this.convert.getControlPoint(this.panel, e.getPoint());
            ControlPoint closestPoint = this.curveModel.locateClosestPoint(clickPoint, this.convert.convertPanelDistance(this.panel, 12.0));
            this.selectionModel.setSelection(closestPoint);
        } else {
            this.selectionModel.setSelection(null);
        }
    }
}

