/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import gui.PointSelectionListener;
import java.util.HashSet;
import java.util.Set;

public class PointSelectionModel {
    private Set<PointSelectionListener> listenerSet = new HashSet<PointSelectionListener>();
    private static final ControlPoint NO_SELECTION = null;
    private ControlPoint selectedPoint = NO_SELECTION;

    public void addPointSelectionListener(PointSelectionListener l) {
        this.listenerSet.add(l);
    }

    public void removePointSelectionListener(PointSelectionListener l) {
        this.listenerSet.remove(l);
    }

    protected void fireSelectionChanged() {
        for (PointSelectionListener listener : this.listenerSet) {
            listener.valueChanged(this);
        }
    }

    public ControlPoint getSelectedPoint() {
        return this.selectedPoint;
    }

    public void undoSelection() {
        if (this.selectedPoint != NO_SELECTION) {
            this.selectedPoint.setSelected(false);
            this.selectedPoint = NO_SELECTION;
            this.fireSelectionChanged();
        }
    }

    public boolean isSelected() {
        return this.selectedPoint != NO_SELECTION;
    }

    public void setSelection(ControlPoint newPoint) {
        if (this.selectedPoint != newPoint) {
            if (this.selectedPoint != NO_SELECTION) {
                this.selectedPoint.setSelected(false);
            }
            this.selectedPoint = newPoint;
            if (this.selectedPoint != NO_SELECTION) {
                this.selectedPoint.setSelected(true);
            }
            this.fireSelectionChanged();
        }
    }
}

