/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveModel;
import gui.CoordinateConvertor;
import gui.CurvePanelToolAdapter;
import gui.CurveViewPanel;
import gui.DefaultPointRenderer;
import gui.PointRenderer;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class RotateTool
extends CurvePanelToolAdapter {
    private CurveModel model;
    private double oldX;
    private double oldY;
    private int centerOldX;
    private int centerOldY;
    private ControlPoint center;
    private double angle;
    private double oldPhi;
    private PointRenderer drawingPoint;
    private boolean draggingPoint;
    private boolean firstTimer;

    public RotateTool(CurveViewPanel panel, CurveModel model) {
        super(panel);
        this.model = model;
        this.drawingPoint = new DefaultPointRenderer();
        panel.repaint();
        this.firstTimer = true;
        this.draggingPoint = false;
    }

    public void setRotationPoint(ControlPoint center) {
        this.center = center;
    }

    public ControlPoint getRotationPoint(ControlPoint center) {
        return center;
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.repositionRotationPoint(e);
            this.draggingPoint = true;
        }
    }

    private void repositionRotationPoint(MouseEvent e) {
        CoordinateConvertor conv = this.panel.getCoordinateConvertor();
        ControlPoint rotationControlPoint = conv.getControlPoint(this.panel, e.getPoint());
        double distance = conv.convertPanelDistance(this.panel, 12.0);
        this.center = this.model.locateClosestPoint(rotationControlPoint, distance);
        if (this.center == null) {
            this.center = conv.getControlPoint(this.panel, e.getPoint());
        }
        this.panel.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.draggingPoint) {
            this.repositionRotationPoint(e);
            return;
        }
        CoordinateConvertor conv = this.panel.getCoordinateConvertor();
        Point rotationPoint = conv.getPanelPoint(this.panel, this.center);
        double deltaX = (double)e.getX() - this.oldX;
        double deltaY = (double)e.getY() - this.oldY;
        double muX = (double)e.getX() - rotationPoint.getX();
        double muY = (double)e.getY() - rotationPoint.getY();
        double phi = Math.atan(muX / muY);
        if (muY < 0.0) {
            phi += Math.PI;
        }
        this.angle = -(phi - this.oldPhi);
        this.model.rotate(this.angle, this.center);
        this.oldX = e.getX();
        this.oldY = e.getY();
        this.oldPhi = phi;
    }

    public void mouseReleased(MouseEvent e) {
        this.model.snapToGrid(this.model.getGridModel());
        this.draggingPoint = false;
    }

    public void paintComponent(Graphics2D g2) {
        CoordinateConvertor conv = this.panel.getCoordinateConvertor();
        if (this.firstTimer) {
            Point panelCenter = new Point(this.panel.getWidth() / 2, this.panel.getHeight() / 2);
            this.center = conv.getControlPoint(this.panel, panelCenter);
            this.firstTimer = false;
        }
        Point rotationPoint = conv.getPanelPoint(this.panel, this.center);
        this.drawingPoint.drawPoint(g2, rotationPoint, 6, false);
    }

    public Cursor getCursor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(RotateTool.class.getResource("images/rotate.png")).getImage(), new Point(5, 5), "rotate");
    }
}

