/*
 * Decompiled with CFR 0.152.
 */
package gui;

import config.OptionModel;
import curve.CurveEvent;
import curve.CurveList;
import curve.CurveListener;
import curve.CurveModel;
import gui.ControlPointSliderPanel;
import gui.CurveFittingCoordinateConvertor;
import gui.CurveViewPanel;
import gui.GridModel;
import gui.PointSelectTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SliderWindow
extends JDialog
implements CurveListener,
WindowListener {
    private static final Dimension POINT_SELECT_PANEL_SIZE = new Dimension(400, 300);
    private CurveModel curveModel;
    private ControlPointSliderPanel sliderPanel;

    public SliderWindow(Frame parent, OptionModel optionModel, CurveList curveList) {
        super(parent, "Slider venster");
        CurveModel curveModel = curveList.getSelectedCurve();
        this.setDefaultCloseOperation(0);
        this.curveModel = curveModel;
        curveModel.addCurveListener(this);
        this.addWindowListener(this);
        this.sliderPanel = new ControlPointSliderPanel(curveModel);
        CurveFittingCoordinateConvertor curveFitter = new CurveFittingCoordinateConvertor(curveModel);
        CurveViewPanel pointSelectPanel = new CurveViewPanel(optionModel, curveFitter, curveList);
        pointSelectPanel.setPreferredSize(POINT_SELECT_PANEL_SIZE);
        pointSelectPanel.setCoordinateConvertor(curveFitter);
        pointSelectPanel.setTool(new PointSelectTool(pointSelectPanel, curveModel));
        pointSelectPanel.setGridModel(new GridModel());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)pointSelectPanel, "Center");
        mainPanel.add((Component)this.sliderPanel, "South");
        this.setContentPane(mainPanel);
        this.pack();
    }

    public void curveChanged(CurveEvent e) {
        if (e.isNrOfPointsChanged()) {
            this.sliderPanel.updateSliders();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.curveModel.getPointSelectionModel().undoSelection();
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

