/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CurvePanelToolAdapter;
import gui.CurveViewPanel;
import gui.ZoomableCoordinateConvertor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ZoomTool
extends CurvePanelToolAdapter {
    private Point grabbedPoint = null;
    private Point endPoint;
    private boolean dragging = false;
    private boolean zooming = false;
    private boolean zoomingIn;
    private ZoomableCoordinateConvertor zoomConvert;

    public ZoomTool(CurveViewPanel p, ZoomableCoordinateConvertor zoomConvert) {
        super(p);
        this.zoomConvert = zoomConvert;
    }

    public void mousePressed(MouseEvent e) {
        if (this.zooming) {
            return;
        }
        if (e.getButton() == 1) {
            this.grabbedPoint = e.getPoint();
            this.zoomingIn = true;
        } else {
            this.zoomingIn = false;
        }
        this.zooming = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.grabbedPoint == null) {
            return;
        }
        if (this.grabbedPoint.distance(e.getPoint()) < 25.0) {
            return;
        }
        this.dragging = true;
        this.endPoint = e.getPoint();
        this.panel.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.zooming) {
            return;
        }
        this.zooming = false;
        if (this.zoomingIn && e.getButton() != 1) {
            this.grabbedPoint = null;
            this.dragging = false;
            this.zoomingIn = false;
            this.panel.repaint();
            return;
        }
        if (!this.dragging) {
            double factor = this.zoomConvert.getRadius();
            factor = this.zoomingIn ? (factor /= 2.0) : (factor *= 2.0);
            this.zoomConvert.setZoomArea(factor, this.zoomConvert.getControlPoint(this.panel, e.getPoint()));
            this.grabbedPoint = null;
            return;
        }
        this.dragging = false;
        Point2D.Double begin = new Point2D.Double(Math.min(this.grabbedPoint.getX(), this.endPoint.getX()), Math.min(this.grabbedPoint.getY(), this.endPoint.getY()));
        Point2D.Double end = new Point2D.Double(Math.max(this.grabbedPoint.getX(), this.endPoint.getX()), Math.max(this.grabbedPoint.getY(), this.endPoint.getY()));
        Point center = new Point((int)((((Point2D)begin).getX() + ((Point2D)end).getX()) / 2.0), (int)((((Point2D)begin).getY() + ((Point2D)end).getY()) / 2.0));
        double radius = Math.min(center.getX() - ((Point2D)begin).getX(), center.getY() - ((Point2D)begin).getY());
        this.zoomConvert.setZoomArea(this.zoomConvert.convertPanelDistance(this.panel, radius), this.zoomConvert.getControlPoint(this.panel, center));
        this.grabbedPoint = null;
    }

    public void paintComponent(Graphics2D g2) {
        if (!this.dragging) {
            return;
        }
        Point2D.Double begin = new Point2D.Double(Math.min(this.grabbedPoint.getX(), this.endPoint.getX()), Math.min(this.grabbedPoint.getY(), this.endPoint.getY()));
        Point2D.Double end = new Point2D.Double(Math.max(this.grabbedPoint.getX(), this.endPoint.getX()), Math.max(this.grabbedPoint.getY(), this.endPoint.getY()));
        Rectangle2D.Double rect = new Rectangle2D.Double(((Point2D)begin).getX(), ((Point2D)begin).getY(), ((Point2D)end).getX() - ((Point2D)begin).getX(), ((Point2D)end).getY() - ((Point2D)begin).getY());
        g2.setColor(new Color(38, 71, 169, 127));
        g2.fill(rect);
        float[] dash = new float[]{10.0f, 10.0f};
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, dash, 0.0f));
        g2.setColor(new Color(150, 150, 150));
        rect.setRect(rect.getX() - 1.0, rect.getY() - 1.0, rect.getWidth() + 1.0, rect.getHeight() + 1.0);
        g2.draw(rect);
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(1);
    }
}

