/*
 * Decompiled with CFR 0.152.
 */
package gui;

import curve.ControlPoint;
import curve.CurveList;
import curve.CurveModel;
import curve.CurvePoint;
import gui.CoordinateConvertor;
import gui.CoordinateListener;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;

public class ZoomableCoordinateConvertor
implements CoordinateConvertor {
    private Set<CoordinateListener> listenerSet = new HashSet<CoordinateListener>();
    private double centerX = 0.5;
    private double centerY = 0.5;
    private static final double MAX_FACTOR = 55.0;
    private static final double MIN_FACTOR = 0.01;
    private double zoomFactor = 1.0;

    public void addCoordinateListener(CoordinateListener l) {
        this.listenerSet.add(l);
    }

    public void removeCoordinateListener(CoordinateListener l) {
        this.listenerSet.remove(l);
    }

    protected void fireZoomChanged() {
        for (CoordinateListener listener : this.listenerSet) {
            listener.coordinatesChanged();
        }
    }

    private int viewSize(JPanel panel) {
        return (int)((double)Math.min(panel.getHeight(), panel.getWidth()) * this.zoomFactor);
    }

    public Point getPanelPoint(JPanel panel, CurvePoint point) {
        int viewSize = this.viewSize(panel);
        int hMargin = (panel.getHeight() - viewSize) / 2;
        int wMargin = (panel.getWidth() - viewSize) / 2;
        int centerXpanel = panel.getWidth() / 2;
        int centerYpanel = panel.getHeight() / 2;
        int newCenterXpanel = wMargin + (int)(this.centerX * (double)viewSize);
        int newCenterYpanel = hMargin + (int)(this.centerY * (double)viewSize);
        int deltaX = centerXpanel - newCenterXpanel;
        int deltaY = centerYpanel - newCenterYpanel;
        return new Point(wMargin + deltaX + (int)(point.getHomX() * (double)viewSize), hMargin + deltaY + (int)(point.getHomY() * (double)viewSize));
    }

    public ControlPoint getControlPoint(JPanel panel, Point point) {
        int viewSize = this.viewSize(panel);
        int hMargin = (panel.getHeight() - viewSize) / 2;
        int wMargin = (panel.getWidth() - viewSize) / 2;
        int centerXpanel = panel.getWidth() / 2;
        int centerYpanel = panel.getHeight() / 2;
        int newCenterXpanel = wMargin + (int)(this.centerX * (double)viewSize);
        int newCenterYpanel = hMargin + (int)(this.centerY * (double)viewSize);
        int deltaX = centerXpanel - newCenterXpanel;
        int deltaY = centerYpanel - newCenterYpanel;
        return new ControlPoint((point.getX() - (double)deltaX - (double)wMargin) / (double)viewSize, (point.getY() - (double)deltaY - (double)hMargin) / (double)viewSize);
    }

    private void setZoomFactor(double zoomFactor) {
        if (Math.abs(zoomFactor - this.zoomFactor) >= 1.0E-4) {
            this.zoomFactor = zoomFactor > 0.01 ? (zoomFactor < 55.0 ? zoomFactor : 55.0) : 0.01;
        }
        this.fireZoomChanged();
    }

    public double convertPointDistance(JPanel panel, double distance) {
        return distance * (double)this.viewSize(panel);
    }

    public double convertPanelDistance(JPanel panel, double distance) {
        return distance / (double)this.viewSize(panel);
    }

    public void translateX(double x) {
        this.centerX += x;
        this.fireZoomChanged();
    }

    public void translateY(double y) {
        this.centerY += y;
        this.fireZoomChanged();
    }

    public void setCenterPoint(CurvePoint point) {
        this.centerX = point.getHomX();
        this.centerY = point.getHomY();
        this.fireZoomChanged();
    }

    public void setCenterPoint(double centerX, double centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.fireZoomChanged();
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public CurvePoint getCenterPoint() {
        return new CurvePoint(this.centerX, this.centerY);
    }

    public void setRadius(double radius) {
        this.setZoomFactor(1.0 / (2.0 * radius));
    }

    public double getRadius() {
        return 1.0 / (2.0 * this.zoomFactor);
    }

    public void setZoomArea(double radius, CurvePoint point) {
        this.centerX = point.getHomX();
        this.centerY = point.getHomY();
        this.setZoomFactor(1.0 / (2.0 * radius));
    }

    public void setZoomArea(double radius, double centerX, double centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.setZoomFactor(1.0 / (2.0 * radius));
    }

    public void restoreDefault() {
        this.centerX = 0.5;
        this.centerY = 0.5;
        this.setZoomFactor(1.0);
    }

    public void setOptimalZoom(CurveModel curveModel) {
        ZoomArea area = this.calcOptimalZoom(curveModel);
        if (area != null) {
            this.setZoomArea(area.radius, area.center);
        }
    }

    private ZoomArea calcOptimalZoom(CurveModel curveModel) {
        ZoomArea zoomArea = new ZoomArea();
        if (curveModel.getNrOfPoints() < 1) {
            return null;
        }
        Iterator<CurvePoint> it = curveModel.approxCurve().iterator();
        Iterator<ControlPoint> it2 = curveModel.iterator();
        if (curveModel.getNrOfPoints() == 1) {
            zoomArea.radius = 0.5;
            zoomArea.center = it2.next();
        } else {
            CurvePoint point = it.next();
            zoomArea.lowX = (zoomArea.highX = point.getHomX());
            zoomArea.lowY = (zoomArea.highY = point.getHomY());
            zoomArea.validRange = true;
            while (it.hasNext()) {
                point = it.next();
                if (zoomArea.lowX < point.getHomX()) {
                    zoomArea.lowX = point.getHomX();
                }
                if (zoomArea.lowY < point.getHomY()) {
                    zoomArea.lowY = point.getHomY();
                }
                if (zoomArea.highX > point.getHomX()) {
                    zoomArea.highX = point.getHomX();
                }
                if (!(zoomArea.highY > point.getHomY())) continue;
                zoomArea.highY = point.getHomY();
            }
            while (it2.hasNext()) {
                point = it2.next();
                if (zoomArea.lowX < point.getHomX()) {
                    zoomArea.lowX = point.getHomX();
                }
                if (zoomArea.lowY < point.getHomY()) {
                    zoomArea.lowY = point.getHomY();
                }
                if (zoomArea.highX > point.getHomX()) {
                    zoomArea.highX = point.getHomX();
                }
                if (!(zoomArea.highY > point.getHomY())) continue;
                zoomArea.highY = point.getHomY();
            }
            zoomArea.center = CurvePoint.getCenterPoint(new CurvePoint(zoomArea.lowX, zoomArea.lowY), new CurvePoint(zoomArea.highX, zoomArea.highY));
            zoomArea.radius = Math.max(Math.abs(zoomArea.highX - zoomArea.lowX), Math.abs(zoomArea.highY - zoomArea.lowY)) / 2.0 * 1.02;
        }
        return zoomArea;
    }

    public void setOptimalZoom(CurveList curveList) {
        ZoomArea zoomArea = this.calcOptimalZoom(curveList.getCurve(0));
        for (int i = 1; i < curveList.nrOfCurves(); ++i) {
            ZoomArea curveArea = this.calcOptimalZoom(curveList.getCurve(i));
            if (zoomArea == null && curveArea != null) {
                zoomArea = curveArea;
                continue;
            }
            if (curveArea == null || !curveArea.validRange) continue;
            if (zoomArea.lowX < curveArea.lowX) {
                zoomArea.lowX = curveArea.lowX;
            }
            if (zoomArea.lowY < curveArea.lowY) {
                zoomArea.lowY = curveArea.lowY;
            }
            if (zoomArea.highX > curveArea.highX) {
                zoomArea.highX = curveArea.highX;
            }
            if (!(zoomArea.highY > curveArea.highY)) continue;
            zoomArea.highY = curveArea.highY;
        }
        if (zoomArea != null) {
            zoomArea.center = CurvePoint.getCenterPoint(new CurvePoint(zoomArea.lowX, zoomArea.lowY), new CurvePoint(zoomArea.highX, zoomArea.highY));
            zoomArea.radius = Math.max(Math.abs(zoomArea.highX - zoomArea.lowX), Math.abs(zoomArea.highY - zoomArea.lowY)) / 2.0 * 1.02;
            this.setZoomArea(zoomArea.radius, zoomArea.center);
        }
    }

    private class ZoomArea {
        private boolean validRange = false;
        private double lowX;
        private double highX;
        private double lowY;
        private double highY;
        private double radius;
        private CurvePoint center;

        private ZoomArea() {
        }
    }
}

