/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.BSplineTree;
import GrafischeTechnieken.BasisMatrix;
import GrafischeTechnieken.GTPolynomial;
import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.Graad;
import GrafischeTechnieken.GraadManipulatieVenster;
import GrafischeTechnieken.GrafischeEngine;
import GrafischeTechnieken.Knoop;
import GrafischeTechnieken.KnopenManipulatieVenster;
import GrafischeTechnieken.Kromme;
import GrafischeTechnieken.OutputVenster;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.TekenVenster;
import java.util.LinkedList;
import java.util.ListIterator;

public class BSpline
extends GrafischeEngine {
    BasisMatrix[] itsBasisMatrices;
    BSplineTree itsRenderTree;
    LinkedList listOfTrees;
    Kromme[] segments;
    Kromme curve;

    public BSpline(GebruikersInterface gui) {
        super(gui);
        this.itsGraad = new Graad();
        this.isOpen = false;
    }

    public void berekenCurve() {
        int k = this.itsGraad.getValue() + 1;
        double[] knots = new double[this.itsKnoop.size() + k];
        double density = 0.0;
        if (this.itsControlePunt.size() >= k - 1) {
            density = 50.0;
            this.listOfTrees = new LinkedList();
            int nSegments = this.itsControlePunt.size() - k + 1;
            knots = this.getKnotsAsDoubles();
            Punt[] points = new Punt[this.itsControlePunt.size()];
            Object[] pobj = this.itsControlePunt.toArray();
            for (int i = 0; i < pobj.length; ++i) {
                points[i] = (Punt)pobj[i];
            }
            this.segments = new Kromme[nSegments];
            BSplineTree.constructSegmentTrees(this.listOfTrees, nSegments, k, points);
            this.calcCurveUp(density, knots);
            this.calcBasisMatrix(knots);
        }
        this.outputBasisMatrix();
        this.outputPolynomes(knots);
        this.outputToTekenVenster();
        this.outputCurve();
    }

    public void flushInputs() {
        this.itsGebruikersInterface.getItsOutputVenster().setItsKromme(this.curve);
        TekenVenster tekenVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsTekenVenster();
        KnopenManipulatieVenster knopenVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsKnopenManipulatieVenster();
        OutputVenster outputVenster = this.itsGebruikersInterface.getItsOutputVenster();
        GraadManipulatieVenster graadVenster = this.itsGebruikersInterface.getItsMenuVenster().getItsGraadManipulatieVenster();
        this.itsGebruikersInterface.getItsMenuVenster().setBigTitle("B-Spline  (k=" + (this.itsGraad.getValue() + 1) + ")");
        tekenVenster.setItsDataPunt(this.itsDataPunt);
        tekenVenster.setItsControlePunt(this.itsControlePunt);
        tekenVenster.setItsSplines(this.segments);
        knopenVenster.setItsKnoop(this.itsKnoop);
        outputVenster.setItsSplines(this.segments);
        graadVenster.setItsGraad(this.itsGraad);
        this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().setBigTitle("B-spline");
    }

    public void outputBasisMatrix() {
        this.itsGebruikersInterface.getItsOutputVenster().getItsBasisMatrixVenster().setMatrices(this.itsBasisMatrices);
    }

    private double[] getKnotsAsDoubles() {
        int i;
        int k = this.itsGraad.getValue() + 1;
        ListIterator knoopIter = this.itsKnoop.listIterator(0);
        double[] knots = new double[this.itsControlePunt.size() + k];
        for (i = k - 2; i < this.itsControlePunt.size() + k - 2; ++i) {
            Knoop knoop = (Knoop)knoopIter.next();
            knots[i] = knoop.getValue();
        }
        for (i = 0; i <= k - 2; ++i) {
            knots[i] = this.isOpen ? knots[k - 1] : (double)(i - k + 2);
        }
        for (i = knots.length - k + 1; i < knots.length; ++i) {
            knots[i] = this.isOpen ? knots[knots.length - k] : knots[i - 1] + 1.0;
        }
        return knots;
    }

    public void calcCurveUp(double density, double[] knots) {
        ListIterator iterCurves = this.listOfTrees.listIterator(0);
        this.segments = new Kromme[this.listOfTrees.size()];
        int nSegment = 0;
        int k = this.itsGraad.getValue() + 1;
        while (iterCurves.hasNext()) {
            BSplineTree segmentRenderTree = (BSplineTree)iterCurves.next();
            double[] xCurve = new double[(int)density + 1];
            double[] yCurve = new double[(int)density + 1];
            int len = knots.length;
            double id = knots[nSegment + k - 1];
            for (int i = 0; i <= (int)density; ++i) {
                segmentRenderTree.initFlags(true);
                double[] cPoint = segmentRenderTree.calc(id, knots);
                xCurve[i] = cPoint[0];
                yCurve[i] = cPoint[1];
                id += (knots[nSegment + k] - knots[nSegment + k - 1]) / density;
            }
            this.segments[nSegment] = new Kromme(xCurve, yCurve);
            ++nSegment;
        }
    }

    public void calcBasisMatrix(double[] knots) {
        int k = this.itsGraad.getValue() + 1;
        LinkedList leafList = new LinkedList();
        this.itsBasisMatrices = new BasisMatrix[this.listOfTrees.size()];
        ListIterator iterCurves = this.listOfTrees.listIterator(0);
        while (iterCurves.hasNext()) {
            BSplineTree itsRenderTree = (BSplineTree)iterCurves.next();
            itsRenderTree.getLeafs(leafList);
        }
        for (int nSegment = 0; nSegment < this.listOfTrees.size(); ++nSegment) {
            this.itsBasisMatrices[nSegment] = new BasisMatrix();
            iterCurves = this.listOfTrees.listIterator(0);
            while (iterCurves.hasNext()) {
                ((BSplineTree)iterCurves.next()).initFlags(true);
            }
            ((BSplineTree)this.listOfTrees.get((int)nSegment)).poly = new GTPolynomial(1.0);
            for (int i = nSegment; i < nSegment + k; ++i) {
                GTPolynomial poly = ((BSplineTree)leafList.get(i)).calcPolynomial(knots);
                this.itsBasisMatrices[nSegment].addCol(poly);
            }
        }
    }

    public void verwijderCurve() {
        super.verwijderCurve();
        this.segments = null;
        this.itsBasisMatrices = null;
        this.flushInputs();
    }

    public void outputToTekenVenster() {
        this.itsGebruikersInterface.getItsMenuVenster().getItsTekenVenster().setItsSplines(this.segments);
        this.itsGebruikersInterface.getItsMenuVenster().setBigTitle("B-Spline  (k=" + (this.itsGraad.getValue() + 1) + ")");
    }

    public void outputCurve() {
        this.itsGebruikersInterface.getItsOutputVenster().setItsSplines(this.segments);
    }

    public void outputPolynomes(double[] knots) {
        int k = this.itsGraad.getValue() + 1;
        if (this.itsBasisMatrices != null) {
            this.itsGebruikersInterface.getItsOutputVenster().getItsGrafiekVenster().setInputData(this.itsBasisMatrices, knots, k);
        }
    }
}

