/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.GTPolynomial;
import GrafischeTechnieken.Punt;
import GrafischeTechnieken.Tree;
import java.util.LinkedList;

public class BSplineTree
extends Tree {
    double X;
    double Y;
    int p;
    int y;
    Punt[] points;
    GTPolynomial poly = new GTPolynomial();
    boolean flag = false;
    boolean dFlag = false;
    BSplineTree lChild;
    BSplineTree rChild;
    BSplineTree rParent;
    BSplineTree lParent;

    public BSplineTree() {
    }

    public BSplineTree(int rangeStart, Punt[] points, int k) {
        this();
        this.p = this.y = rangeStart;
        this.poly = new GTPolynomial(1.0);
        this.lChild = new BSplineTree(rangeStart, rangeStart, points, k, 1, this);
        this.rChild = new BSplineTree(rangeStart + 1, rangeStart + 1, points, k, 0, this);
    }

    public BSplineTree(int p, int y, Punt[] points, int k, int parentParity, BSplineTree parent) {
        this();
        this.p = p;
        this.y = y;
        if (parent != null) {
            if (parentParity == 0) {
                this.lParent = parent;
            } else {
                this.rParent = parent;
            }
        }
        if (y - p == k - 2) {
            this.X = points[p - 1].getX();
            this.Y = points[p - 1].getY();
            this.flag = true;
        } else {
            this.lChild = this.lParent != null && this.lParent.lChild != null && this.lParent.lChild.rChild != null ? this.lParent.lChild.rChild : new BSplineTree(p - 1, y, points, k, 1, this);
            this.lChild.rParent = this;
            this.rChild = this.rParent != null && this.rParent.rChild != null && this.rParent.rChild.lChild != null ? this.rParent.rChild.lChild : new BSplineTree(p, y + 1, points, k, 0, this);
            this.rChild.lParent = this;
        }
    }

    public static void constructSegmentTrees(LinkedList ll, int nSegments, int k, Punt[] points) {
        while (ll.size() < nSegments) {
            if (ll.size() == 0) {
                ll.add(new BSplineTree(ll.size() + k - 1, points, k));
                continue;
            }
            BSplineTree nextSegmentTree = new BSplineTree();
            nextSegmentTree.p = nextSegmentTree.y = ll.size() + k - 1;
            nextSegmentTree.poly = new GTPolynomial(1.0);
            nextSegmentTree.lChild = ((BSplineTree)ll.getLast()).rChild;
            ((BSplineTree)ll.getLast()).rChild.rParent = nextSegmentTree;
            nextSegmentTree.lChild.rParent = nextSegmentTree;
            nextSegmentTree.rChild = new BSplineTree(ll.size() + k, ll.size() + k, points, k, 0, nextSegmentTree);
            ll.add(nextSegmentTree);
        }
    }

    public void getLeafs(LinkedList l) {
        if (this.lChild != null) {
            this.lChild.getLeafs(l);
        } else if (!l.contains(this)) {
            l.add(this);
        }
        if (this.rChild != null) {
            this.rChild.getLeafs(l);
        } else if (!l.contains(this)) {
            l.add(this);
        }
    }

    public void initFlags(boolean flag) {
        this.flag = false;
        this.dFlag = false;
        this.poly = new GTPolynomial();
        if (this.lChild != null) {
            this.lChild.initFlags(flag);
        } else {
            this.flag = flag;
            this.dFlag = false;
        }
        if (this.rChild != null) {
            this.rChild.initFlags(flag);
        } else {
            this.flag = flag;
            this.dFlag = false;
        }
    }

    public double[] calc(double u, double[] knots) {
        if (this.flag) {
            double[] pair = new double[]{this.X, this.Y};
            return pair;
        }
        double[] lP = this.lChild.calc(u, knots);
        double[] rP = this.rChild.calc(u, knots);
        double[] pair = new double[2];
        double ty = knots[this.y + 1];
        double tp = this.lParent == null && this.rParent == null ? knots[this.p] : knots[this.p - 1];
        for (int i = 0; i < 2; ++i) {
            pair[i] = lP[i] * (ty - u) / (ty - tp) + rP[i] * (u - tp) / (ty - tp);
        }
        this.X = pair[0];
        this.Y = pair[1];
        this.flag = true;
        return pair;
    }

    public GTPolynomial calcPolynomial(double[] knots) {
        double rtp;
        double rty;
        double ltp;
        double lty;
        if (this.lParent == null && this.rParent == null) {
            return this.poly;
        }
        if (this.dFlag) {
            return this.poly;
        }
        GTPolynomial lPoly = new GTPolynomial();
        GTPolynomial rPoly = new GTPolynomial();
        if (this.lParent != null) {
            lty = knots[this.y];
            ltp = knots[this.p - 1];
        } else {
            lty = 0.0;
            ltp = 1.0;
        }
        if (this.rParent != null) {
            rty = knots[this.y + 1];
            rtp = knots[this.p];
        } else {
            rty = 0.0;
            rtp = 1.0;
        }
        lPoly.add(-ltp / (lty - ltp));
        lPoly.add(1.0 / (lty - ltp));
        rPoly.add(rty / (rty - rtp));
        rPoly.add(-1.0 / (rty - rtp));
        lPoly = this.lParent != null ? this.lParent.calcPolynomial(knots).multiply(lPoly) : new GTPolynomial(0.0);
        rPoly = this.rParent != null ? this.rParent.calcPolynomial(knots).multiply(rPoly) : new GTPolynomial(0.0);
        this.poly = lPoly.sum(rPoly);
        this.dFlag = true;
        return this.poly;
    }
}

