/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.BasisMatrix;
import GrafischeTechnieken.Window;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;

public class BasisMatrixVenster
extends Window {
    protected BasisMatrix[] matrices;
    protected BasisMatrix matrix;
    protected JPanel contentPane;
    boolean multipleMatrices;

    public BasisMatrixVenster() {
        super(250, 200);
        this.setTitle("BasisMatrix");
        this.contentPane = new JPanel();
        this.contentPane.setBackground(new Color(200, 200, 200));
        this.setStretchablePane(this.contentPane);
        this.pack();
    }

    public void setMatrix(BasisMatrix matrix) {
        this.multipleMatrices = false;
        this.matrix = matrix;
        this.renewContent();
    }

    public void setMatrices(BasisMatrix[] matrices) {
        this.multipleMatrices = true;
        this.matrices = matrices;
        this.renewContent();
    }

    public void renewContent() {
        this.contentPane.removeAll();
        if (!this.multipleMatrices && this.matrix == null || this.multipleMatrices && this.matrices == null) {
            return;
        }
        if (this.multipleMatrices) {
            JTabbedPane tabPane = new JTabbedPane(4);
            int nMatrix = 0;
            for (nMatrix = 0; nMatrix < this.matrices.length; ++nMatrix) {
                JPanel matrixPane = new JPanel(new GridLayout(this.matrices[nMatrix].getSize(), this.matrices[nMatrix].getSize(), 5, 5));
                for (int i = 0; i < this.matrices[nMatrix].getSize(); ++i) {
                    for (int j = 0; j < this.matrices[nMatrix].getSize(); ++j) {
                        JLabel valLabel = new JLabel(this.matrices[nMatrix].getElementAt(j, i) + "", 0);
                        valLabel.setBackground(new Color(240, 250, 250));
                        valLabel.setBorder(new EtchedBorder());
                        matrixPane.add(valLabel);
                    }
                }
                tabPane.add(nMatrix + "", matrixPane);
                this.contentPane.setLayout(new BorderLayout());
                this.contentPane.add(tabPane);
            }
            if (nMatrix == 1) {
                this.setBigTitle("B-Matrix");
            } else {
                this.setBigTitle("B-Matrices (" + nMatrix + ")");
            }
            if (!this.isIcon()) {
                this.pack();
            }
        } else {
            this.contentPane.setLayout(new GridLayout(this.matrix.getSize(), this.matrix.getSize(), 5, 5));
            for (int i = 0; i < this.matrix.getSize(); ++i) {
                for (int j = 0; j < this.matrix.getSize(); ++j) {
                    JLabel valLabel = new JLabel(this.matrix.getElementAt(j, i) + "", 0);
                    valLabel.setBackground(new Color(240, 250, 250));
                    valLabel.setBorder(new EtchedBorder());
                    this.contentPane.add(valLabel);
                }
            }
            this.setBigTitle("LagrangeMatrix");
            if (!this.isIcon()) {
                this.pack();
            }
        }
    }
}

