/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.ControlePunt;
import GrafischeTechnieken.DataPunt;
import GrafischeTechnieken.GTGeneralWindowFrame;
import GrafischeTechnieken.GTGeneralWindowPane;
import GrafischeTechnieken.MenuVenster;
import GrafischeTechnieken.PuntenVenster;
import GrafischeTechnieken.TextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class ConsoleVenster
extends JFrame {
    public static final Color neutralGray = new Color(200, 200, 200);
    protected MenuVenster itsMenuVenster;
    protected TextArea itsTextArea;
    protected JLabel outputLabel;

    public ConsoleVenster() {
        this.initRelations();
        this.placeOutputPane();
        this.placeTextPane(400, 200);
        this.setTitle("Console");
        this.pack();
    }

    private void placeTextPane(int prefW, int prefH) {
        JScrollPane scrollPane = new JScrollPane(this.itsTextArea);
        scrollPane.setBorder(new CompoundBorder(new MatteBorder(new Insets(10, 10, 10, 10), neutralGray), new EtchedBorder()));
        JPanel cPane = new JPanel(new BorderLayout());
        GTGeneralWindowPane mPane = new GTGeneralWindowPane(prefW, prefH, 34, 12, 13, 13, 1.0, 1.0, scrollPane);
        cPane.add((Component)mPane, "Center");
        cPane.setBorder(new MatteBorder(new Insets(10, 10, 10, 10), GTGeneralWindowFrame.beige));
        mPane.setBigTitle("Input");
        this.getContentPane().add(cPane);
    }

    private void placeOutputPane() {
        JPanel pane = new JPanel(new BorderLayout());
        GTGeneralWindowPane gPane = new GTGeneralWindowPane(240, 80, 34, 12, 13, 13, 1.0, 1.0, this.outputLabel);
        pane.add(gPane);
        pane.setBorder(new MatteBorder(new Insets(10, 10, 10, 10), GTGeneralWindowFrame.beige));
        gPane.setBigTitle("Output");
        this.getContentPane().add((Component)pane, "South");
    }

    public void executeCommand(int id, String[] params) {
        switch (id) {
            case 0: {
                if (this.itsMenuVenster.getItsTekenVenster().getType() == 0) {
                    this.voegtoeDataPunt(params[0], params[1]);
                } else {
                    this.voegtoeControlePunt(params[0], params[1]);
                }
                this.itsMenuVenster.getItsKnopenManipulatieVenster().addKnoop();
                this.berekenCurve();
                break;
            }
            case 1: {
                if (this.itsMenuVenster.getItsTekenVenster().getType() == 0) {
                    this.verwijderDataPunt(params[0]);
                } else {
                    this.verwijderControlePunt(params[0]);
                }
                this.maakUniform();
                this.berekenCurve();
                break;
            }
            case 2: {
                if (this.itsMenuVenster.getItsTekenVenster().getType() == 0) {
                    this.verplaatsDataPunt(params[0], params[1], params[2]);
                } else {
                    this.verplaatsControlePunt(params[0], params[1], params[2]);
                }
                this.berekenCurve();
                break;
            }
            case 3: {
                this.verplaatsAfgeleide(params[0], params[1], params[2]);
                this.berekenCurve();
                break;
            }
            case 4: {
                this.verwijderAfgeleide(params[0]);
                this.verwijderTweedeAfgeleide(params[0]);
                this.berekenCurve();
                break;
            }
            case 5: {
                this.verplaatsTweedeAfgeleide(params[0], params[1], params[2]);
                this.berekenCurve();
                break;
            }
            case 6: {
                this.verwijderTweedeAfgeleide(params[0]);
                this.berekenCurve();
                break;
            }
            case 7: {
                this.voegtoeKnoop(params[0]);
                this.berekenCurve();
                break;
            }
            case 8: {
                this.maakUniform();
                this.berekenCurve();
                break;
            }
            case 9: {
                this.maakOpenUniform();
                this.berekenCurve();
                break;
            }
            case 10: {
                this.wijzigGraad(params[0]);
                this.berekenCurve();
                break;
            }
            case 11: {
                this.berekenCurve();
                break;
            }
            case 12: {
                this.verwijderCurve();
                break;
            }
            case 13: {
                this.veranderCurve(params[0]);
                break;
            }
            case 14: {
                this.veranderType(params[0]);
                break;
            }
            case 15: {
                this.save(params[0]);
                break;
            }
            case 16: {
                this.load(params[0]);
                this.berekenCurve();
                break;
            }
            case 17: {
                this.save2png(params[0]);
            }
        }
    }

    public void berekenCurve() {
        this.itsMenuVenster.getItsGrafischeEngine().berekenCurve();
    }

    public void bewaarPuntSequentie() {
    }

    public void configureerEngine() {
    }

    public void gebruikGraad() {
    }

    public void herschaalAssen() {
    }

    public void laadGTScript() {
    }

    public void laadPuntSequentie() {
    }

    public void maakLeeg() {
    }

    public void verplaatsControlePunt(String index, String x, String y) {
        int indexInt = Integer.parseInt(index);
        double dx = Double.parseDouble(x);
        double dy = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().verplaatsControlePunt(indexInt, new ControlePunt(dx, dy));
    }

    public void verplaatsDataPunt(String index, String x, String y) {
        int indexInt = Integer.parseInt(index);
        double dx = Double.parseDouble(x);
        double dy = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().verplaatsDataPunt(indexInt, new DataPunt(dx, dy));
    }

    public void verplaatsKnoop() {
    }

    public void verplaatsAfgeleide(String index, String x, String y) {
        int indexInt = Integer.parseInt(index);
        double dx = Double.parseDouble(x);
        double dy = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().verplaatsAfgeleide(indexInt, new DataPunt(dx, dy));
    }

    public void verwijderAfgeleide(String index) {
        int indexInt = Integer.parseInt(index);
        this.itsMenuVenster.getItsGrafischeEngine().verwijderAfgeleide(indexInt);
    }

    public void verplaatsTweedeAfgeleide(String index, String x, String y) {
        int indexInt = Integer.parseInt(index);
        double dx = Double.parseDouble(x);
        double dy = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().verplaatsTweedeAfgeleide(indexInt, new DataPunt(dx, dy));
    }

    public void verwijderTweedeAfgeleide(String index) {
        int indexInt = Integer.parseInt(index);
        this.itsMenuVenster.getItsGrafischeEngine().verwijderTweedeAfgeleide(indexInt);
    }

    public void verwijderControlePunt(String index) {
        int indexInt = Integer.parseInt(index);
        this.itsMenuVenster.getItsGrafischeEngine().verwijderControlePunt(indexInt);
    }

    public void verwijderDataPunt(String index) {
        int indexInt = Integer.parseInt(index);
        this.itsMenuVenster.getItsGrafischeEngine().verwijderDataPunt(indexInt);
    }

    public void verzetOorsprong() {
    }

    public void voegtoeControlePunt(String x, String y) {
        double xd = Double.parseDouble(x);
        double yd = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().voegtoeControlePunt(new ControlePunt(xd, yd));
    }

    public void voegtoeDataPunt(String x, String y) {
        double xd = Double.parseDouble(x);
        double yd = Double.parseDouble(y);
        this.itsMenuVenster.getItsGrafischeEngine().voegtoeDataPunt(new DataPunt(xd, yd));
    }

    public void save(String filename) {
        try {
            RandomAccessFile out = new RandomAccessFile(filename, "rw");
            out.writeLong(-559038737L);
            out.writeInt(this.itsMenuVenster.getCurveSelectPane().getType());
            this.itsMenuVenster.getItsGrafischeEngine().saveToFile(out);
        }
        catch (IOException e) {
            System.out.println("problem writing output file!");
        }
    }

    public void load(String filename) {
        try {
            RandomAccessFile in = new RandomAccessFile(filename, "r");
            long first = in.readLong();
            if (first != -559038737L) {
                System.out.println("invalid curve file");
                return;
            }
            this.verwijderCurve();
            int type = in.readInt();
            this.veranderType(type + "");
            this.itsMenuVenster.getItsGrafischeEngine().loadFromFile(in);
        }
        catch (IOException e) {
            System.out.println("problem reading input file!");
        }
    }

    public void save2png(String filename) {
        try {
            this.itsMenuVenster.getItsGrafischeEngine().getItsGebruikersInterface().getItsOutputVenster().saveOutputToPng(filename);
        }
        catch (IOException e) {
            System.out.println("problem writing image file");
        }
    }

    public void voegtoeKnoop(String knoop_val) {
        double dval = Double.parseDouble(knoop_val);
        this.itsMenuVenster.getItsGrafischeEngine().voegtoeKnoop(dval);
    }

    public void verwijderCurve() {
        this.itsMenuVenster.getItsGrafischeEngine().verwijderCurve();
    }

    public void veranderCurve(String index) {
        int indexInt = Integer.parseInt(index);
        this.itsMenuVenster.getCurveSelectPane().setActiveLabel(indexInt - 1);
    }

    public void veranderType(String type) {
        int nieuwType = Integer.parseInt(type);
        this.itsMenuVenster.getCurveSelectPane().veranderType(nieuwType);
    }

    public void wijzigGraad(String graad) {
        int graadInt = Integer.parseInt(graad);
        this.itsMenuVenster.getItsGrafischeEngine().wijzigGraad(graadInt);
    }

    public void maakUniform() {
        this.itsMenuVenster.getItsGrafischeEngine().maakUniform();
    }

    public void maakOpenUniform() {
        this.itsMenuVenster.getItsGrafischeEngine().maakOpenUniform();
    }

    public PuntenVenster getItsMenuVenster() {
        return this.itsMenuVenster;
    }

    public void _setItsMenuVenster(MenuVenster p_MenuVenster) {
        this.itsMenuVenster = p_MenuVenster;
        this.itsMenuVenster.setItsConsoleVenster(this);
    }

    public TextArea getItsTextArea() {
        return this.itsTextArea;
    }

    public void __setItsTextArea(TextArea p_TextArea) {
        this.itsTextArea = p_TextArea;
    }

    public void _setItsTextArea(TextArea p_TextArea) {
        if (this.itsTextArea != null) {
            this.itsTextArea.__setItsConsoleVenster(null);
        }
        this.__setItsTextArea(p_TextArea);
    }

    public TextArea newItsTextArea(JLabel outputLabel) {
        this.itsTextArea = new TextArea(outputLabel);
        this.itsTextArea._setItsConsoleVenster(this);
        return this.itsTextArea;
    }

    public void deleteItsTextArea() {
        this.itsTextArea.__setItsConsoleVenster(null);
        this.itsTextArea = null;
    }

    protected void initRelations() {
        this.outputLabel = new JLabel("<html><P align=center><font size=2>[this window will display command info]</html>");
        this.outputLabel.setBorder(new EmptyBorder(new Insets(0, 20, 0, 20)));
        this.itsTextArea = this.newItsTextArea(this.outputLabel);
    }
}

