/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.CurveSelectPane;
import GrafischeTechnieken.GTGeneralWindowFrame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class CurveSelectLabel
extends JLabel
implements MouseListener {
    Color mouseOver = new Color(250, 250, 200);
    Color[] activeColor = new Color[3];
    boolean isActive;
    int number;
    int WIDTH = 15;
    int HEIGHT = 15;
    int type;
    Color bgColor;
    CurveSelectPane parent;

    public CurveSelectLabel(int number, CurveSelectPane parent, int type) {
        this.setBackground(GTGeneralWindowFrame.beige);
        this.number = number;
        this.parent = parent;
        this.addMouseListener(this);
        this.setFont(new Font("Monospaced", 1, 9));
        this.type = type;
        this.isActive = false;
        this.activeColor[0] = new Color(250, 200, 200);
        this.activeColor[1] = new Color(210, 220, 250);
        this.activeColor[2] = new Color(200, 240, 210);
        this.bgColor = this.activeColor[type];
    }

    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isActive) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            g.setColor(Color.white);
            g.drawRect(0, 0, this.WIDTH, this.HEIGHT);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            g.setColor(Color.black);
            g.drawRect(0, 0, this.WIDTH, this.HEIGHT);
        } else {
            g.setColor(new Color(Math.min(255, this.bgColor.getRed() + 20), Math.min(255, this.bgColor.getGreen() + 20), Math.min(255, this.bgColor.getBlue() + 20), 120));
            g.fillRoundRect(0, 0, this.WIDTH, this.HEIGHT, 5, 5);
            g.setColor(new Color(120, 120, 120));
            g.drawRoundRect(0, 0, this.WIDTH, this.HEIGHT, 5, 5);
        }
        if (this.isActive) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.darkGray);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.number < 10) {
            g.drawString("" + this.number, 6, 11);
        } else {
            g.drawString("" + this.number, 3, 11);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH + 1, this.HEIGHT + 1);
    }

    public void setUnactive() {
        this.isActive = false;
        this.repaint();
    }

    public void setType(int type) {
        this.type = type;
        this.bgColor = this.activeColor[type];
        this.repaint();
    }

    public int getType() {
        return this.type;
    }

    public void setActive() {
        this.isActive = true;
        this.bgColor = this.activeColor[this.type];
        this.repaint();
    }

    public int getId() {
        return this.number;
    }

    public void mousePressed(MouseEvent e) {
        this.bgColor = this.activeColor[this.type];
        this.parent.setActive(this);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.isActive) {
            this.bgColor = this.mouseOver;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.bgColor == this.mouseOver) {
            this.bgColor = this.activeColor[this.type];
            this.repaint();
        }
    }
}

