/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.BSpline;
import GrafischeTechnieken.Bezier;
import GrafischeTechnieken.CurveSelectLabel;
import GrafischeTechnieken.GTGeneralWindowFrame;
import GrafischeTechnieken.GebruikersInterface;
import GrafischeTechnieken.Neville;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;

public class CurveSelectPane
extends JPanel
implements ActionListener {
    int aantal;
    int WIDTH = 80;
    int HEIGHT = 120;
    CurveSelectLabel activeLabel;
    CurveSelectLabel[] labels;
    GebruikersInterface GUI;
    JMenuItem lagrange;
    JMenuItem bspline;
    JMenuItem bezier;
    JMenuItem graad;

    public CurveSelectPane(GebruikersInterface GUI) {
        this.GUI = GUI;
        this.setLayout(new BoxLayout(this, 1));
        JPanel cPane = new JPanel(new GridLayout(4, 4, 4, 4));
        Font smallFont = new Font("SansSerif", 1, 11);
        this.setBackground(GTGeneralWindowFrame.beige);
        cPane.setBackground(GTGeneralWindowFrame.beige);
        this.aantal = 16;
        this.labels = new CurveSelectLabel[this.aantal];
        for (int i = 0; i < this.aantal; ++i) {
            this.labels[i] = new CurveSelectLabel(i + 1, this, i / 4 % 3);
            cPane.add(this.labels[i]);
        }
        this.graad = new JMenuItem("Graad...");
        cPane.setBorder(new MatteBorder(new Insets(5, 4, 2, 4), GTGeneralWindowFrame.beige));
        this.setBorder(new CompoundBorder(new MatteBorder(new Insets(0, 18, 10, 13), GTGeneralWindowFrame.beige), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), " Curve # ", 2, 2, smallFont, Color.black)));
        this.add(cPane);
        JPanel menuPane = new JPanel();
        JMenuBar menuBar1 = new JMenuBar();
        JMenu menu1 = new JMenu("    Opties    ");
        JMenu menu2 = new JMenu("Type");
        this.lagrange = new JRadioButtonMenuItem("Lagrange");
        menu2.add(this.lagrange);
        this.bspline = new JRadioButtonMenuItem("B-Spline");
        menu2.add(this.bspline);
        this.bezier = new JRadioButtonMenuItem("B\u00e9zier");
        menu2.add(this.bezier);
        ButtonGroup group = new ButtonGroup();
        group.add(this.lagrange);
        group.add(this.bspline);
        group.add(this.bezier);
        this.lagrange.addActionListener(this);
        this.bspline.addActionListener(this);
        this.bezier.addActionListener(this);
        menu2.add(new JSeparator());
        menu2.add(this.graad);
        this.graad.addActionListener(this);
        menu1.add(menu2);
        menu1.add(new JSeparator());
        menu1.setBorder(new EtchedBorder());
        menuBar1.add(menu1);
        menuPane.add(menuBar1);
        menuBar1.setBackground(GTGeneralWindowFrame.beige);
        menuBar1.setBorder(new EmptyBorder(new Insets(0, 0, -1, 0)));
        menuPane.setBackground(GTGeneralWindowFrame.beige);
        menu1.setBackground(new Color(216, 238, 235));
        menu2.setBackground(new Color(250, 216, 215));
        this.setActive(this.labels[0]);
        this.add(menuPane);
        JPanel iconPane = new JPanel(new GridLayout(3, 0));
        Font miniFont = new Font("Dialog", 1, 10);
        JLabel iconLabel = new JLabel("= lagrange", new ImageIcon("images/lagrange_icon.png"), 2);
        iconLabel.setFont(miniFont);
        iconLabel.setOpaque(false);
        iconPane.add(iconLabel);
        iconLabel = new JLabel("= b-spline", new ImageIcon("images/bspline_icon.png"), 2);
        iconLabel.setFont(miniFont);
        iconLabel.setOpaque(false);
        iconPane.add(iconLabel);
        iconLabel = new JLabel("= b\u00e9zier", new ImageIcon("images/bezier_icon.png"), 2);
        iconLabel.setFont(miniFont);
        iconLabel.setOpaque(false);
        iconPane.add(iconLabel);
        iconPane.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        iconPane.setOpaque(false);
        this.add(iconPane);
    }

    public void setActive(CurveSelectLabel activeLabel) {
        int oldType = this.activeLabel == null ? 0 : this.activeLabel.getType();
        if (this.activeLabel != null) {
            this.activeLabel.setUnactive();
        }
        this.activeLabel = activeLabel;
        activeLabel.setActive();
        int newType = activeLabel.getType();
        switch (newType) {
            case 0: {
                this.lagrange.setSelected(true);
                this.graad.setEnabled(false);
                break;
            }
            case 1: {
                this.bspline.setSelected(true);
                this.graad.setEnabled(true);
                break;
            }
            case 2: {
                this.bezier.setSelected(true);
                this.graad.setEnabled(false);
            }
        }
        this.GUI.getItsMenuVenster().getItsMenu().setTypeSelected(newType);
        this.GUI.setActiveGrafischeEngine(activeLabel.getId() - 1);
        this.GUI.getItsMenuVenster().getItsTekenVenster().changeTypeOfCurve(oldType, activeLabel.getType());
        this.GUI.flushGrafischeEngineInputs();
    }

    public void setActiveLabel(int nIndex) {
        if (nIndex >= 0 && nIndex < this.aantal) {
            this.setActive(this.labels[nIndex]);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public int getMaxNumberOfCurves() {
        return this.aantal;
    }

    public int getType() {
        if (this.activeLabel != null) {
            return this.activeLabel.getType();
        }
        return 0;
    }

    public void veranderType(int nieuw_type) {
        switch (nieuw_type) {
            case 0: {
                if (this.activeLabel.getType() == 0) break;
                int oldType = this.activeLabel.getType();
                this.activeLabel.setType(0);
                this.GUI.setItsGrafischeEngine(new Neville(this.GUI), this.activeLabel.getId() - 1);
                this.graad.setEnabled(false);
                this.GUI.getItsMenuVenster().getItsMenu().setTypeSelected(0);
                this.GUI.setActiveGrafischeEngine(this.activeLabel.getId() - 1);
                this.GUI.getItsMenuVenster().getItsTekenVenster().changeTypeOfCurve(oldType, this.activeLabel.getType());
                this.GUI.flushGrafischeEngineInputs();
                break;
            }
            case 1: {
                if (this.activeLabel.getType() == 1) break;
                int oldType = this.activeLabel.getType();
                this.activeLabel.setType(1);
                this.GUI.setItsGrafischeEngine(new BSpline(this.GUI), this.activeLabel.getId() - 1);
                this.graad.setEnabled(true);
                this.GUI.getItsMenuVenster().getItsMenu().setTypeSelected(1);
                this.GUI.setActiveGrafischeEngine(this.activeLabel.getId() - 1);
                this.GUI.getItsMenuVenster().getItsTekenVenster().changeTypeOfCurve(oldType, this.activeLabel.getType());
                this.GUI.flushGrafischeEngineInputs();
                break;
            }
            case 2: {
                if (this.activeLabel.getType() == 2) break;
                int oldType = this.activeLabel.getType();
                this.activeLabel.setType(2);
                this.GUI.setItsGrafischeEngine(new Bezier(this.GUI), this.activeLabel.getId() - 1);
                this.graad.setEnabled(false);
                this.GUI.getItsMenuVenster().getItsMenu().setTypeSelected(2);
                this.GUI.setActiveGrafischeEngine(this.activeLabel.getId() - 1);
                this.GUI.getItsMenuVenster().getItsTekenVenster().changeTypeOfCurve(oldType, this.activeLabel.getType());
                this.GUI.flushGrafischeEngineInputs();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("Graad...")) {
            this.GUI.getItsMenuVenster().getItsGraadManipulatieVenster().show();
        }
        if (str.equals("Lagrange")) {
            this.veranderType(0);
        }
        if (str.equals("B-Spline")) {
            this.veranderType(1);
        }
        if (str.equals("B\u00e9zier")) {
            this.veranderType(2);
        }
    }
}

