/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.GTToolPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class GTDrawingCanvas
extends JPanel {
    BufferedImage bgBuf;
    BufferedImage gridBuf;
    Graphics2D gridBufG;
    int mWidth;
    int mHeight;
    boolean withBG;
    GTToolPane tools;

    public GTDrawingCanvas(boolean withBG) {
        this.tools = null;
        this.withBG = withBG;
        try {
            if (withBG) {
                this.bgBuf = ImageIO.read(new File("images/GTW_center_bg.jpg"));
            }
        }
        catch (IOException e) {
            System.out.println("problem reading image files. check your paths.");
            System.exit(0);
        }
    }

    public GTDrawingCanvas(GTToolPane tools) {
        this.tools = tools;
        try {
            this.bgBuf = ImageIO.read(new File("images/GTW_center_bg.png"));
        }
        catch (IOException e) {
            System.out.println("problem reading image files. check your paths.");
            System.exit(0);
        }
    }

    public void redrawGrid() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.gridBuf = new BufferedImage(this.mWidth, this.mHeight, 1);
        this.gridBufG = this.gridBuf.createGraphics();
        this.gridBufG.setColor(new Color(200, 200, 200));
        if (this.withBG) {
            this.gridBufG.drawImage(this.bgBuf, 0, 0, this.getWidth(), this.getHeight(), this);
        } else {
            this.gridBufG.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Dimension getPreferredWidth() {
        return new Dimension(this.mWidth, this.mHeight);
    }
}

