/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GTGeneralWindowPane
extends JPanel
implements ComponentListener {
    JFrame parentFrame;
    int mWIDTH = 513;
    int mHEIGHT = 519;
    double hFactor;
    double vFactor;
    int th;
    int bh;
    int lw;
    int rw;
    BufferedImage gtw_tl;
    BufferedImage gtw_tt;
    BufferedImage gtw_tstretch;
    BufferedImage gtw_tspace;
    BufferedImage gtw_tr;
    BufferedImage gtw_lstretch;
    BufferedImage gtw_cbg;
    BufferedImage gtw_rstretch;
    BufferedImage gtw_bl;
    BufferedImage gtw_bstretch;
    BufferedImage gtw_br;
    HorStretchPane tPanel;
    VertStretchPane lPanel;
    JPanel centerPanel;
    HorStretchPane bPanel;
    VertStretchPane rPanel;
    BufferedImage bg_buffer;
    Graphics2D bg_graphics;

    public GTGeneralWindowPane(int dWidth, int dHeight, int tHeight, int bHeight, int lWidth, int rWidth, double hFactor, double vFactor, JComponent cPane) {
        super(new BorderLayout());
        this.collectImages();
        this.mWIDTH = dWidth;
        this.mHEIGHT = dHeight;
        this.th = tHeight;
        this.bh = bHeight;
        this.lw = lWidth;
        this.rw = rWidth;
        this.hFactor = hFactor;
        this.vFactor = vFactor;
        this.tPanel = new HorStretchPane(this.gtw_tl, 13, this.gtw_tt, 128, this.gtw_tstretch, this.gtw_tspace, 78, this.gtw_tr, 13, this.mWIDTH, tHeight);
        this.bPanel = new HorStretchPane(this.gtw_bl, 13, this.gtw_tt, 0, this.gtw_bstretch, this.gtw_tspace, 0, this.gtw_br, 13, this.mWIDTH, bHeight);
        this.lPanel = new VertStretchPane(this.gtw_lstretch, lWidth, 473);
        this.rPanel = new VertStretchPane(this.gtw_rstretch, rWidth, 473);
        this.add(cPane);
        this.add((Component)this.tPanel, "North");
        this.add((Component)this.bPanel, "South");
        this.add((Component)this.lPanel, "West");
        this.add((Component)this.rPanel, "East");
        this.addComponentListener(this);
    }

    public void setStretchablePane(JPanel p) {
        this.centerPanel = p;
    }

    public void collectImages() {
        try {
            this.gtw_tl = ImageIO.read(new File("images/GTW_top_left.png"));
            this.gtw_tt = ImageIO.read(new File("images/GTW_generic_title.png"));
            this.gtw_tstretch = ImageIO.read(new File("images/GTW_top_stretch.png"));
            this.gtw_tspace = ImageIO.read(new File("images/GTW_top_space.png"));
            this.gtw_tr = ImageIO.read(new File("images/GTW_top_right.png"));
            this.gtw_lstretch = ImageIO.read(new File("images/GTW_left_stretch.png"));
            this.gtw_cbg = ImageIO.read(new File("images/GTW_center_bg.png"));
            this.gtw_rstretch = ImageIO.read(new File("images/GTW_right_stretch.png"));
            this.gtw_bl = ImageIO.read(new File("images/GTW_bottom_left.png"));
            this.gtw_bstretch = ImageIO.read(new File("images/GTW_bottom_stretch.png"));
            this.gtw_br = ImageIO.read(new File("images/GTW_bottom_right.png"));
        }
        catch (IOException e) {
            System.out.println("problem reading image files. check your paths.");
            System.exit(0);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.mWIDTH, this.mHEIGHT);
    }

    public void setSize(int width, int height) {
        this.mWIDTH = width;
        this.mHEIGHT = height;
        this.tPanel.setNewWidth(width);
        this.bPanel.setNewWidth(width);
        this.lPanel.setNewHeight(height);
        this.rPanel.setNewHeight(height);
    }

    public void setBigTitle(String bTitle) {
        this.tPanel.setBigTitle(bTitle);
    }

    public void setSubTitle(String sTitle, int sWidth) {
        this.tPanel.setSubTitle(sTitle, sWidth);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Dimension d = e.getComponent().getSize();
        int nWidth = (int)(d.getWidth() * this.hFactor);
        int nHeight = (int)(d.getHeight() * this.vFactor);
        this.setSize(nWidth, nHeight);
        this.tPanel.repaint();
        this.rPanel.repaint();
        this.tPanel.repaint();
        this.bPanel.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    private class HorStretchPane
    extends JPanel {
        int hWidth;
        int hHeight;
        int lw;
        int tw;
        int spw;
        int rw;
        int stretchWidth;
        BufferedImage left;
        BufferedImage title;
        BufferedImage stretch;
        BufferedImage space;
        BufferedImage right;
        Font titleFont;
        Font subTitleFont;
        String bTitle;
        String sTitle;
        int subTitleWidth;

        public HorStretchPane(BufferedImage left, int lw, BufferedImage title, int tw, BufferedImage stretch, BufferedImage space, int spw, BufferedImage right, int rw, int defaultWidth, int height) {
            super(null);
            this.titleFont = new Font("Dialog", 1, 14);
            this.subTitleFont = new Font("Dialog", 1, 11);
            this.left = left;
            this.right = right;
            this.title = title;
            this.stretch = stretch;
            this.space = space;
            this.lw = lw;
            this.rw = rw;
            this.spw = spw;
            this.tw = tw;
            this.hWidth = defaultWidth;
            this.hHeight = height;
            this.sTitle = "";
            this.bTitle = "";
            this.subTitleWidth = 0;
            this.stretchWidth = defaultWidth - lw - rw - spw - tw;
        }

        public void paintComponent(Graphics g) {
            int curwidth = 0;
            g.drawImage(this.left, 0, 0, this);
            curwidth += this.lw;
            if (this.tw != 0) {
                g.drawImage(this.title, curwidth, 0, this);
            }
            curwidth += this.tw;
            if (this.stretchWidth > 0) {
                g.drawImage(this.stretch, curwidth, 0, this.stretchWidth, this.hHeight, this);
            }
            curwidth += this.stretchWidth;
            if (this.spw != 0) {
                g.drawImage(this.space, curwidth, 0, this);
            }
            curwidth += this.spw;
            if (this.rw != 0) {
                g.drawImage(this.right, curwidth, 0, this);
            }
            if (this.tw != 0) {
                g.setColor(Color.darkGray);
                g.setFont(this.titleFont);
                g.drawString(this.bTitle, this.lw + 20, 22);
                g.setFont(this.subTitleFont);
                g.drawString(this.sTitle, this.lw + this.hWidth - this.subTitleWidth, 22);
            }
            curwidth += this.rw;
        }

        public void setBigTitle(String bTitle) {
            this.bTitle = bTitle;
            this.repaint();
        }

        public void setSubTitle(String sTitle, int subTitleWidth) {
            this.sTitle = sTitle;
            this.subTitleWidth = subTitleWidth;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.hWidth, this.hHeight);
        }

        public void setNewWidth(int width) {
            this.hWidth = width;
            this.stretchWidth = this.hWidth - this.lw - this.rw - this.spw - this.tw;
            this.repaint();
        }
    }

    private class VertStretchPane
    extends JPanel {
        int vWidth;
        int vHeight;
        BufferedImage stretch;

        public VertStretchPane(BufferedImage stretch, int vWidth, int vHeight) {
            this.stretch = stretch;
            this.vWidth = vWidth;
            this.vHeight = vHeight;
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.stretch, 0, 0, this.vWidth, this.vHeight, this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.vWidth, this.vHeight);
        }

        public void setNewHeight(int height) {
            this.vHeight = height;
        }
    }
}

