/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.GTToolPane;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class GTToolLabel
extends JLabel
implements MouseListener {
    String description;
    BufferedImage toolImg;
    BufferedImage buf;
    Graphics2D bufG;
    GTToolPane parent;
    static Color beige = new Color(228, 228, 219);
    static Color neutral = new Color(240, 240, 240);
    static Color active = new Color(250, 210, 210);
    static Color mouseover = new Color(210, 250, 210);
    int id;
    static int imgW = 30;
    static int imgH = 30;
    int state;

    public GTToolLabel(String description, BufferedImage toolImg, GTToolPane parent, int id) {
        this.description = description;
        this.toolImg = toolImg;
        this.parent = parent;
        this.id = id++;
        this.buf = new BufferedImage(imgW, imgH, 3);
        this.bufG = this.buf.createGraphics();
        this.bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.repaintImg();
        this.setText(description);
        this.setBackground(beige);
        this.state = 0;
        this.addMouseListener(this);
    }

    public void setActive() {
        this.state = 1;
        this.parent.setActive(this.id);
        this.repaintImg();
    }

    public void setMouseOver() {
        this.state = 2;
        this.repaintImg();
    }

    public void deActivate() {
        this.state = 0;
        this.repaintImg();
    }

    public void repaintImg() {
        this.bufG.setColor(beige);
        this.bufG.fillRect(0, 0, imgW, imgH);
        switch (this.state) {
            case 0: {
                this.bufG.setColor(neutral);
                this.bufG.fillOval(2, 2, imgW - 4, imgH - 4);
                this.bufG.setColor(Color.black);
                this.bufG.drawOval(2, 2, imgW - 4, imgH - 4);
                this.setForeground(Color.gray);
                break;
            }
            case 1: {
                this.bufG.setColor(active);
                this.bufG.fillRect(2, 2, imgW - 4, imgH - 4);
                this.bufG.setColor(Color.black);
                this.bufG.drawRect(2, 2, imgW - 4, imgH - 4);
                this.setForeground(Color.black);
                break;
            }
            case 2: {
                this.bufG.setColor(mouseover);
                this.bufG.fillOval(2, 2, imgW - 4, imgH - 4);
                this.bufG.setColor(Color.black);
                this.bufG.drawOval(2, 2, imgW - 4, imgH - 4);
                this.setForeground(Color.white);
            }
        }
        this.bufG.drawImage((Image)this.toolImg, 7, 7, this);
        this.setIcon(new ImageIcon(this.buf));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.state != 1) {
            this.setActive();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.state != 1 && this.state != 2) {
            this.setMouseOver();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.state != 1 && this.state != 0) {
            this.deActivate();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }
}

