/*
 * Decompiled with CFR 0.152.
 */
package GrafischeTechnieken;

import GrafischeTechnieken.GTGeneralWindowFrame;
import GrafischeTechnieken.GTToolLabel;
import GrafischeTechnieken.PuntenVenster;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class GTToolPane
extends JPanel {
    GTToolLabel[] labels;
    PuntenVenster parent;
    String[] toolDescr = new String[]{"add", "remove", "move", "zoom", "pan"};
    int nTools = 5;
    int activeID;

    public GTToolPane(PuntenVenster parent) {
        this.parent = parent;
        this.setBackground(GTGeneralWindowFrame.beige);
        JPanel cPane = new JPanel(new GridLayout(0, 1));
        Font smallFont = new Font("SansSerif", 1, 11);
        this.setBorder(new MatteBorder(new Insets(13, 10, 10, 10), GTGeneralWindowFrame.beige));
        cPane.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), " Tools ", 2, 2, smallFont, Color.black), new MatteBorder(new Insets(0, 5, 5, 5), GTGeneralWindowFrame.beige)));
        cPane.setBackground(GTGeneralWindowFrame.beige);
        this.labels = new GTToolLabel[this.nTools];
        try {
            for (int i = 0; i < this.nTools; ++i) {
                this.labels[i] = new GTToolLabel(this.toolDescr[i], ImageIO.read(new File("images/tool_" + i + ".png")), this, i);
                cPane.add(this.labels[i]);
            }
            this.activeID = 0;
            this.labels[this.activeID].setActive();
            this.labels[this.activeID].repaintImg();
            this.add(cPane);
        }
        catch (IOException e) {
            System.out.println("problem reading image files. check your paths.");
            System.exit(0);
        }
    }

    public void setActive(int id) {
        if (this.activeID != id) {
            this.labels[this.activeID].deActivate();
            this.activeID = id;
        }
    }

    public int getMode() {
        return this.activeID;
    }
}

